/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.ForestURL;
import java.io.Serializable;
import java.time.Duration;
import java.util.Date;
import okhttp3.Cookie;
import okhttp3.HttpUrl;
import okhttp3.internal.Util;

public class ForestCookie
implements Cloneable,
Serializable {
    private String name;
    private String value;
    private Date createTime;
    private Duration maxAge;
    private String domain;
    private String path;
    private boolean secure;
    private boolean httpOnly;
    private boolean hostOnly;
    private boolean persistent;

    public ForestCookie(String name, String value) {
        this(name, value, new Date(), Duration.ofMillis(Long.MAX_VALUE), null, "/", false, false, false, false);
    }

    public ForestCookie(String name, String value, Date createTime, Duration maxAge, String domain, String path, boolean secure, boolean httpOnly, boolean hostOnly, boolean persistent) {
        this.name = name;
        this.value = value;
        this.createTime = createTime;
        this.maxAge = maxAge;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.hostOnly = hostOnly;
        this.persistent = persistent;
    }

    public String getName() {
        return this.name;
    }

    public ForestCookie setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public ForestCookie setValue(String value) {
        this.value = value;
        return this;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public ForestCookie setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public ForestCookie setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public ForestCookie setDomain(String domain) {
        if (domain == null) {
            throw new NullPointerException("[Forest] cookie domain is null");
        }
        this.domain = domain;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public ForestCookie setPath(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("[Forest] cookie path must start with '/'");
        }
        this.path = path;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public ForestCookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public ForestCookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean isHostOnly() {
        return this.hostOnly;
    }

    public ForestCookie setHostOnly(boolean hostOnly) {
        this.hostOnly = hostOnly;
        return this;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public ForestCookie setPersistent(boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public static boolean matchDomain(boolean hostOnly, String leftDomain, String rightDomain) {
        if (leftDomain == null) {
            return true;
        }
        if (leftDomain.equals(rightDomain)) {
            return true;
        }
        return !hostOnly && leftDomain.endsWith(rightDomain) && leftDomain.charAt(leftDomain.length() - rightDomain.length() - 1) == '.' && !Util.verifyAsIpAddress((String)leftDomain);
    }

    public boolean matchDomain(String domain) {
        return ForestCookie.matchDomain(this.hostOnly, this.domain, domain);
    }

    public static boolean matchPath(String cookiePath, String urlPath) {
        if (urlPath.equals(cookiePath)) {
            return true;
        }
        if (urlPath.startsWith(cookiePath)) {
            if (cookiePath.endsWith("/")) {
                return true;
            }
            return urlPath.charAt(cookiePath.length()) == '/';
        }
        return false;
    }

    public boolean matchURL(ForestURL url) {
        if (!this.matchSchema(url.getScheme())) {
            return false;
        }
        if (!this.matchDomain(url.getHost())) {
            return false;
        }
        return this.matchPath(url.getPath());
    }

    public boolean matchSchema(String schema) {
        if (!this.secure) {
            return true;
        }
        return "https".equals(schema);
    }

    public boolean matchPath(String path) {
        return ForestCookie.matchPath(this.path, path);
    }

    public boolean isExpired(Date date) {
        long expiredTime = this.getExpiresTime();
        return expiredTime <= date.getTime();
    }

    public static ForestCookie parse(String url, String setCookie) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        long currentTime = System.currentTimeMillis();
        Cookie okCookie = Cookie.parse((HttpUrl)httpUrl, (String)setCookie);
        if (okCookie == null) {
            return null;
        }
        long expiresAt = okCookie.expiresAt();
        long maxAge = expiresAt > currentTime ? expiresAt - currentTime : 0L;
        Date createTime = new Date(currentTime);
        Duration maxAgeDuration = Duration.ofMillis(maxAge);
        return new ForestCookie(okCookie.name(), okCookie.value(), createTime, maxAgeDuration, okCookie.domain(), okCookie.path(), okCookie.secure(), okCookie.httpOnly(), okCookie.hostOnly(), okCookie.persistent());
    }

    public long getExpiresTime() {
        long maxAgeMillis = this.maxAge.toMillis();
        if (maxAgeMillis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.createTime.getTime() + this.maxAge.toMillis();
    }

    public ForestCookie clone() {
        return new ForestCookie(this.name, this.value, this.createTime, this.maxAge, this.domain, this.path, this.secure, this.httpOnly, this.hostOnly, this.persistent);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name);
        result.append('=');
        result.append(this.value);
        if (this.persistent) {
            result.append("; max-age=").append(this.maxAge.getSeconds());
        }
        if (!this.hostOnly) {
            result.append("; domain=");
            result.append(this.domain);
        }
        result.append("; path=").append(this.path);
        if (this.secure) {
            result.append("; secure");
        }
        if (this.httpOnly) {
            result.append("; httponly");
        }
        return result.toString();
    }
}

