/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestResponse;
import com.dtflys.forest.http.ResultGetter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ForestFuture<T>
extends ResultGetter
implements Future<T> {
    private final ForestRequest<T> request;
    private final Future<ForestResponse<T>> future;
    private ForestResponse<T> response;

    public ForestFuture(ForestRequest<T> request, Future<ForestResponse<T>> future) {
        super(request);
        this.request = request;
        this.future = future;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.request.cancel();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.request.isCanceled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    public ForestResponse<T> await() {
        if (this.response == null) {
            try {
                ForestResponse<T> result = this.future.get();
                this.response = result;
            }
            catch (InterruptedException e) {
                throw new ForestRuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new ForestRuntimeException(e);
            }
        }
        return this.response;
    }

    public ForestResponse<T> await(long timeout, TimeUnit unit) {
        if (this.response == null) {
            try {
                this.response = this.future.get(timeout, unit);
            }
            catch (InterruptedException e) {
                throw new ForestRuntimeException(e);
            }
            catch (ExecutionException e) {
                throw new ForestRuntimeException(e);
            }
            catch (TimeoutException e) {
                throw new ForestRuntimeException(e);
            }
        }
        return this.response;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        ForestResponse<T> res = this.await();
        return res.getResult();
    }

    @Override
    public T get(long timeout, @NotNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ForestResponse<T> res = this.await(timeout, unit);
        return res.getResult();
    }

    @Override
    public ForestResponse<T> getResponse() {
        return this.await();
    }
}

