/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.ForestCookie;
import com.dtflys.forest.http.ForestCookieHeader;
import com.dtflys.forest.http.ForestCookies;
import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.ForestSetCookieHeader;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.http.Lazy;
import com.dtflys.forest.http.LazyHeader;
import com.dtflys.forest.http.SimpleHeader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ForestHeaderMap
implements Map<String, String>,
Cloneable {
    private final List<ForestHeader> headers;
    private ForestCookieHeader cookieHeader = null;
    private final List<ForestCookie> requestCookies = new LinkedList<ForestCookie>();
    private final HasURL hasURL;

    public ForestHeaderMap(List<ForestHeader> headers, HasURL hasURL) {
        this.headers = headers;
        this.hasURL = hasURL;
    }

    public ForestHeaderMap(HasURL hasURL) {
        this.headers = new LinkedList<ForestHeader>();
        this.hasURL = hasURL;
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public HasURL getHasURL() {
        return this.hasURL;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String name = key.toString();
        for (ForestHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (ForestHeader header : this.headers) {
            String headerVal = header.getValue();
            if (!(headerVal == null ? value == null : headerVal.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            return null;
        }
        String name = key.toString();
        ForestHeader header = this.getHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    @Override
    public String put(String key, String value) {
        ForestHeader header = this.getHeader(key);
        if (header != null) {
            if (header instanceof SimpleHeader) {
                ((SimpleHeader)header).setValue(value);
            } else {
                this.remove(header);
                this.addHeader(key, value);
            }
        } else if ("Cookie".equalsIgnoreCase(key)) {
            ForestCookie cookie = ForestCookie.parse(this.hasURL.url().toURLString(), value);
            if (cookie != null) {
                ForestSetCookieHeader cookieHeader = ForestSetCookieHeader.fromCookie(this.hasURL, cookie);
                this.addHeader(cookieHeader);
            }
        } else if ("Set-Cookie".equalsIgnoreCase(key)) {
            ForestCookie cookie = ForestCookie.parse(this.hasURL.url().toURLString(), value);
            if (cookie != null) {
                ForestSetCookieHeader cookieHeader = ForestSetCookieHeader.fromSetCookie(this.hasURL, cookie);
                this.addHeader(cookieHeader);
            }
        } else {
            SimpleHeader newHeader = new SimpleHeader(key, value);
            this.addHeader(newHeader);
        }
        return value;
    }

    @Override
    public String remove(Object key) {
        if (key == null) {
            return null;
        }
        String name = key.toString();
        for (int i = this.headers.size() - 1; i >= 0; --i) {
            ForestHeader header = this.headers.get(i);
            if (!header.getName().equalsIgnoreCase(name)) continue;
            ForestHeader removedHeader = this.headers.remove(i);
            return removedHeader.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<? extends String, ? extends String> entry : m.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            this.put(name, value);
        }
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (ForestHeader header : this.headers) {
            set.add(header.getName());
        }
        return set;
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> list = new ArrayList<String>();
        for (ForestHeader header : this.headers) {
            String val = header.getValue();
            if (val == null) continue;
            list.add(val);
        }
        return list;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> set = new HashSet<Map.Entry<String, String>>();
        for (final ForestHeader header : this.headers) {
            Map.Entry<String, String> entry = new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return header.getName();
                }

                @Override
                public String getValue() {
                    return header.getValue();
                }

                @Override
                public String setValue(String value) {
                    String oldValue = header.getValue();
                    header.setValue(value);
                    return oldValue;
                }
            };
            set.add(entry);
        }
        return set;
    }

    public String getValue(String name) {
        ForestHeader header = this.getHeader(name);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public List<String> getValues(String name) {
        ArrayList<String> results = new ArrayList<String>(2);
        for (ForestHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            results.add(header.getValue());
        }
        return Collections.unmodifiableList(results);
    }

    public ForestHeader getHeader(String name) {
        for (ForestHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public List<ForestCookie> getSetCookies() {
        ArrayList<ForestCookie> list = new ArrayList<ForestCookie>();
        for (ForestHeader header : this.headers) {
            if (!(header instanceof ForestSetCookieHeader)) continue;
            list.add(((ForestSetCookieHeader)header).getCookie());
        }
        return list;
    }

    public ForestCookie getSetCookie(String name) {
        if (name == null) {
            return null;
        }
        for (ForestHeader header : this.headers) {
            ForestCookie cookie;
            if (!(header instanceof ForestSetCookieHeader) || (cookie = ((ForestSetCookieHeader)header).getCookie()) == null || !name.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public List<ForestHeader> getHeaders(String name) {
        ArrayList<ForestHeader> results = new ArrayList<ForestHeader>(2);
        for (ForestHeader header : this.headers) {
            if (!header.getName().equalsIgnoreCase(name)) continue;
            results.add(header);
        }
        return results;
    }

    public List<String> names() {
        ArrayList<String> results = new ArrayList<String>(this.headers.size());
        for (ForestHeader header : this.headers) {
            results.add(header.getName());
        }
        return Collections.unmodifiableList(results);
    }

    public List<String> getValues() {
        ArrayList<String> results = new ArrayList<String>(this.headers.size());
        for (ForestHeader header : this.headers) {
            results.add(header.getValue());
        }
        return Collections.unmodifiableList(results);
    }

    public void addHeader(ForestHeader header) {
        this.headers.add(header);
    }

    public void addHeader(String name, String value) {
        if ("Cookie".equalsIgnoreCase(name)) {
            ForestCookies cookies = ForestCookies.parse(value);
            if (cookies.size() > 0) {
                this.addCookies(cookies);
            }
        } else if ("Set-Cookie".equalsIgnoreCase(name)) {
            ForestCookie cookie = ForestCookie.parse(this.hasURL.url().toURLString(), value);
            if (cookie != null) {
                ForestSetCookieHeader cookieHeader = ForestSetCookieHeader.fromSetCookie(this.hasURL, cookie);
                this.addHeader(cookieHeader);
            }
        } else {
            this.addHeader(new SimpleHeader(name, value));
        }
    }

    public void addHeader(String name, Lazy<?> value) {
        this.addHeader(new LazyHeader(this, name, value));
    }

    public void addCookie(ForestCookie cookie) {
        this.addCookie(cookie, true);
    }

    public void addCookie(ForestCookie cookie, boolean strict) {
        if (this.cookieHeader == null) {
            ForestCookieHeader cookieHeaderTmp = new ForestCookieHeader(this.hasURL);
            if (cookieHeaderTmp.addCookie(cookie, strict)) {
                this.cookieHeader = cookieHeaderTmp;
                this.addHeader(this.cookieHeader);
            }
        } else {
            this.cookieHeader.addCookie(cookie, strict);
        }
    }

    public void addCookies(List<ForestCookie> cookies) {
        for (ForestCookie cookie : cookies) {
            this.addCookie(cookie);
        }
    }

    public void addCookies(List<ForestCookie> cookies, boolean strict) {
        for (ForestCookie cookie : cookies) {
            this.addCookie(cookie, strict);
        }
    }

    public void addCookies(ForestCookies cookies) {
        this.addCookies(cookies.allCookies(), cookies.strict());
    }

    public void setHeader(String name, String value) {
        ForestHeader header = this.getHeader(name);
        if (header != null) {
            if (header instanceof SimpleHeader) {
                ((SimpleHeader)header).setValue(value);
            } else {
                this.headers.remove(header);
                this.addHeader(name, value);
            }
        } else {
            this.addHeader(name, value);
        }
    }

    public void setHeader(String name, Lazy<?> lazyValue) {
        ForestHeader header = this.getHeader(name);
        if (header != null) {
            if (header instanceof LazyHeader) {
                ((LazyHeader)header).setValue(lazyValue);
            } else {
                this.headers.remove(header);
                this.addHeader(name, lazyValue);
            }
        } else {
            this.addHeader(name, lazyValue);
        }
    }

    public void setHeader(Map map) {
        if (map == null) {
            return;
        }
        for (Object key : map.keySet()) {
            Object value = map.get(key);
            this.setHeader(String.valueOf(key), String.valueOf(value));
        }
    }

    public Iterator<ForestHeader> headerIterator() {
        return this.headers.iterator();
    }

    public ForestHeaderMap clone(HasURL hasURL) {
        ForestHeaderMap newHeaderMap = new ForestHeaderMap(hasURL);
        for (ForestHeader header : this.headers) {
            newHeaderMap.addHeader((ForestHeader)header.clone(newHeaderMap));
        }
        for (ForestCookie cookie : this.requestCookies) {
            newHeaderMap.requestCookies.add(cookie);
        }
        return newHeaderMap;
    }
}

