/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestProxyType;
import com.dtflys.forest.http.ForestURL;
import com.dtflys.forest.http.ForestURLBuilder;
import com.dtflys.forest.http.HasHeaders;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.utils.RequestNameValue;
import com.dtflys.forest.utils.StringUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class ForestProxy
implements HasURL,
HasHeaders {
    private final ForestProxyType type;
    private final String host;
    private final int port;
    private String charset;
    private String username;
    private String password;
    private ForestHeaderMap headers = new ForestHeaderMap(this);

    public static ForestProxy http(String ip, int port) {
        return new ForestProxy(ip, port);
    }

    public static ForestProxy socks(String ip, int port) {
        return new ForestProxy(ForestProxyType.SOCKS, ip, port);
    }

    public static ForestProxy url(String url) {
        try {
            URL javaUrl = new URL(url);
            String protocol = javaUrl.getProtocol();
            ForestProxyType type = StringUtils.isNotBlank(protocol) && protocol.startsWith("socks") ? ForestProxyType.SOCKS : ForestProxyType.HTTP;
            String userInfo = javaUrl.getUserInfo();
            String username = null;
            String password = null;
            if (StringUtils.isNotEmpty(userInfo)) {
                String[] infos = userInfo.split("\\:");
                if (infos.length > 0) {
                    username = infos[0];
                }
                if (infos.length > 1) {
                    password = infos[1];
                }
            }
            String host = javaUrl.getHost();
            int port = javaUrl.getPort();
            return new ForestProxy(type, host, port).username(username).password(password);
        }
        catch (MalformedURLException e) {
            throw new ForestRuntimeException(e);
        }
    }

    public ForestProxy(String ip, int port) {
        this(ForestProxyType.HTTP, ip, port);
    }

    public ForestProxy(ForestProxyType type, String ip, int port) {
        this.type = type;
        this.host = ip;
        this.port = port;
    }

    public String cacheKey() {
        StringBuilder builder = new StringBuilder(",-x=");
        if (StringUtils.isNotEmpty(this.host)) {
            builder.append(this.host);
        }
        builder.append(":");
        builder.append(this.port);
        if (!this.headers.isEmpty()) {
            builder.append(":");
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.append("h=").append(entry.getKey()).append(":").append(entry.getValue()).append(";");
            }
        }
        return builder.toString();
    }

    public ForestProxyType getType() {
        return this.type;
    }

    public ForestProxyType type() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public String host() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int port() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public ForestProxy setUsername(String username) {
        this.username = username;
        return this;
    }

    public ForestProxy username(String username) {
        this.username = username;
        return this;
    }

    public String getCharset() {
        return this.charset;
    }

    public ForestProxy setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    public ForestProxy charset(String charset) {
        this.charset = charset;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ForestProxy setPassword(String password) {
        this.password = password;
        return this;
    }

    public ForestProxy password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public ForestHeaderMap getHeaders() {
        return this.headers;
    }

    public ForestHeader getHeader(String name) {
        return this.headers.getHeader(name);
    }

    public String getHeaderValue(String name) {
        return this.headers.getValue(name);
    }

    public ForestProxy addHeader(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            return this;
        }
        this.headers.setHeader(name, String.valueOf(value));
        return this;
    }

    public ForestProxy addHeader(RequestNameValue nameValue) {
        this.addHeader(nameValue.getName(), nameValue.getValue());
        return this;
    }

    public ForestProxy addHeaders(List<RequestNameValue> nameValues) {
        for (RequestNameValue nameValue : nameValues) {
            this.addHeader(nameValue.getName(), nameValue.getValue());
        }
        return this;
    }

    @Override
    public ForestURL url() {
        return new ForestURLBuilder().setHost(this.host).setPort(this.port).build();
    }
}

