/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.ForestCookie;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.http.SimpleHeader;

public class ForestSetCookieHeader
extends SimpleHeader {
    private ForestCookie cookie;
    private HasURL hasURL;

    public static ForestSetCookieHeader fromCookie(HasURL hasURL, ForestCookie cookie) {
        return new ForestSetCookieHeader("Cookie", hasURL, cookie);
    }

    public static ForestSetCookieHeader fromSetCookie(HasURL hasURL, ForestCookie cookie) {
        return new ForestSetCookieHeader("Set-Cookie", hasURL, cookie);
    }

    public ForestSetCookieHeader(String headerName, HasURL hasURL, ForestCookie cookie) {
        super(headerName, null);
        this.cookie = cookie;
        this.hasURL = hasURL;
    }

    @Override
    public String getValue() {
        return this.cookie.toString();
    }

    @Override
    public ForestSetCookieHeader setValue(String value) {
        ForestCookie newCookie = ForestCookie.parse(this.hasURL.url().toURLString(), value);
        if (newCookie != null) {
            super.setValue(newCookie.toString());
            this.cookie = newCookie;
        }
        return this;
    }

    public ForestCookie getCookie() {
        return this.cookie;
    }

    public void setCookie(ForestCookie cookie) {
        this.cookie = cookie;
    }
}

