/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestAddress;
import com.dtflys.forest.http.ForestRoute;
import com.dtflys.forest.http.ForestRoutes;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.URLUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForestURL {
    private static final Logger log = LoggerFactory.getLogger(ForestURL.class);
    private String originalUrl;
    private ForestAddress address;
    private String scheme;
    private String host;
    private Integer port;
    private String basePath;
    private String path;
    private String userInfo;
    private String ref;
    private boolean ssl;
    private boolean needRegenerateUrl = false;

    private void needRegenerateUrl() {
        this.needRegenerateUrl = true;
    }

    public ForestURL(URL url) {
        if (url == null) {
            throw new ForestRuntimeException("[Forest] Request url cannot be null!");
        }
        this.setScheme(url.getProtocol());
        this.host = url.getHost();
        this.port = url.getPort();
        this.path = url.getPath();
        this.userInfo = url.getUserInfo();
        this.setRef(url.getRef());
    }

    public ForestURL(String scheme, String userInfo, String host, Integer port, String path) {
        this(scheme, userInfo, host, port, path, null);
    }

    public ForestURL(String scheme, String userInfo, String host, Integer port, String path, String ref) {
        this.setScheme(scheme);
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.ref = ref;
        this.needRegenerateUrl();
    }

    public String getOriginalUrl() {
        if (this.originalUrl == null || this.needRegenerateUrl) {
            this.originalUrl = this.toURLString();
            this.needRegenerateUrl = false;
        }
        return this.originalUrl;
    }

    public ForestURL setBaseAddress(ForestAddress baseAddress) {
        if (baseAddress != null) {
            String baseScheme = baseAddress.getScheme();
            String baseHost = baseAddress.getHost();
            String bastPath = baseAddress.getBasePath();
            int basePort = baseAddress.getPort();
            this.setBasePath(bastPath);
            this.setScheme(baseScheme);
            this.setHost(baseHost);
            if (basePort != -1) {
                this.setPort(basePort);
            }
        }
        return this;
    }

    public String getScheme() {
        if (StringUtils.isEmpty(this.scheme) && this.address != null) {
            return this.address.getScheme();
        }
        if (StringUtils.isEmpty(this.scheme)) {
            return this.ssl ? "https" : "http";
        }
        return this.scheme;
    }

    private void refreshSSL() {
        this.ssl = "https".equals(this.scheme);
    }

    public ForestURL setScheme(String scheme) {
        if (StringUtils.isBlank(scheme)) {
            return this;
        }
        this.scheme = scheme.trim();
        this.refreshSSL();
        this.needRegenerateUrl();
        return this;
    }

    public String getHost() {
        if (StringUtils.isEmpty(this.host) && this.address != null) {
            return this.address.getHost();
        }
        return this.host;
    }

    public ForestURL setHost(String host) {
        if (StringUtils.isBlank(host)) {
            return this;
        }
        this.host = host.trim();
        if (this.host.endsWith("/")) {
            this.host = this.host.substring(0, this.host.lastIndexOf("/"));
        }
        this.needRegenerateUrl();
        return this;
    }

    private static int normalizePort(Integer port, boolean ssl) {
        if (URLUtils.isNonePort(port)) {
            return ssl ? 443 : 80;
        }
        return port;
    }

    public int getPort() {
        if (URLUtils.isNonePort(this.port) && this.address != null) {
            return ForestURL.normalizePort(this.address.getPort(), this.ssl);
        }
        return ForestURL.normalizePort(this.port, this.ssl);
    }

    public ForestURL setPort(int port) {
        this.port = port;
        this.needRegenerateUrl();
        return this;
    }

    public String normalizeBasePath() {
        if (StringUtils.isEmpty(this.basePath)) {
            return this.normalizeBasePath(this.address.getBasePath());
        }
        return this.normalizeBasePath(this.basePath);
    }

    private String normalizeBasePath(String basePath) {
        if (StringUtils.isNotEmpty(basePath) && basePath.charAt(0) != '/') {
            return '/' + basePath;
        }
        return basePath;
    }

    public ForestURL setBasePath(String basePath) {
        return this.setBasePath(basePath, true);
    }

    public ForestURL setBasePath(String basePath, boolean forced) {
        if (basePath == null) {
            return this;
        }
        this.basePath = basePath.trim();
        if (!this.basePath.startsWith("/")) {
            if (URLUtils.isURL(this.basePath)) {
                try {
                    String originHost = this.host;
                    URL url = new URL(this.basePath);
                    if (forced || StringUtils.isEmpty(this.scheme)) {
                        this.setScheme(url.getProtocol());
                    }
                    if (forced || StringUtils.isEmpty(this.userInfo)) {
                        this.userInfo = url.getUserInfo();
                    }
                    if (forced || StringUtils.isEmpty(this.host)) {
                        this.host = url.getHost();
                    }
                    if (forced || URLUtils.isNonePort(this.port) && StringUtils.isEmpty(originHost)) {
                        this.port = url.getPort();
                    }
                    this.basePath = url.getPath();
                }
                catch (MalformedURLException e) {
                    throw new ForestRuntimeException(e);
                }
            } else {
                this.basePath = "/" + this.basePath;
            }
        }
        this.needRegenerateUrl();
        return this;
    }

    public String getPath() {
        if (StringUtils.isNotEmpty(this.path) && this.path.charAt(0) != '/') {
            return '/' + this.path;
        }
        return this.path;
    }

    public ForestURL setPath(String path) {
        if (path == null) {
            return this;
        }
        this.path = path.trim();
        this.needRegenerateUrl();
        return this;
    }

    public String getUserInfo() {
        if (StringUtils.isEmpty(this.userInfo) && this.address != null) {
            return this.address.getUserInfo();
        }
        return this.userInfo;
    }

    public ForestURL setUserInfo(String userInfo) {
        this.userInfo = userInfo;
        this.needRegenerateUrl();
        return this;
    }

    public String getAuthority() {
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotEmpty(this.userInfo)) {
            builder.append(URLUtils.userInfoEncode(this.userInfo, "UTF-8")).append("@");
        }
        if (StringUtils.isNotEmpty(this.host)) {
            builder.append(URLUtils.userInfoEncode(this.host, "UTF-8"));
        }
        if (URLUtils.isNotNonePort(this.port) && (this.port != 80 && this.port != 443 && this.port > -1 || this.port == 80 && !this.ssl || this.port == 443 && !this.ssl)) {
            builder.append(':').append(this.port);
        }
        return builder.toString();
    }

    public String getRef() {
        return this.ref;
    }

    public ForestURL setRef(String ref) {
        this.ref = ref;
        return this;
    }

    public boolean isSSL() {
        if (StringUtils.isEmpty(this.scheme) && this.address != null) {
            return "https".equals(this.address.getScheme());
        }
        return this.ssl;
    }

    public String toURLString() {
        String authority;
        StringBuilder builder = new StringBuilder();
        if (StringUtils.isNotEmpty(this.scheme)) {
            builder.append(this.scheme).append("://");
        }
        if (StringUtils.isNotEmpty(authority = this.getAuthority())) {
            builder.append(authority);
        }
        if (StringUtils.isNotEmpty(this.basePath)) {
            String encodedBasePath = URLUtils.pathEncode(this.basePath, "UTF-8");
            if (this.host != null && encodedBasePath.charAt(0) != '/') {
                builder.append('/');
            }
            builder.append(encodedBasePath);
        }
        if (StringUtils.isNotEmpty(this.path)) {
            String encodedPath = URLUtils.pathEncode(this.path, "UTF-8");
            int len = builder.length() - 1;
            if ((this.host != null || this.basePath != null) && encodedPath.charAt(0) != '/' && builder.charAt(len) != '/') {
                builder.append('/');
                builder.append(encodedPath);
            } else if (encodedPath.length() > 1 && encodedPath.charAt(0) == '/' && builder.charAt(len) == '/') {
                builder.append(encodedPath.substring(1));
            } else {
                builder.append(encodedPath);
            }
        }
        return builder.toString();
    }

    public ForestRoute getRoute() {
        return ForestRoutes.getRoute(this.getHost(), this.getPort());
    }

    public String toString() {
        if (StringUtils.isNotEmpty(this.ref)) {
            return this.getOriginalUrl() + "#" + this.ref;
        }
        return this.getOriginalUrl();
    }

    public URL toJavaURL() {
        try {
            return new URL(this.getOriginalUrl());
        }
        catch (MalformedURLException e) {
            throw new ForestRuntimeException(e);
        }
    }

    public URI toURI() {
        try {
            return new URI(this.getOriginalUrl());
        }
        catch (URISyntaxException e) {
            throw new ForestRuntimeException(e);
        }
    }

    public ForestURL setAddress(ForestAddress address) {
        return this.setAddress(address, true);
    }

    public ForestURL setAddress(ForestAddress address, boolean forced) {
        if (forced) {
            this.setBaseAddress(address);
        } else {
            this.address = address;
        }
        return this;
    }

    public ForestURL mergeURLWith(ForestURL url) {
        if (url == null) {
            return this;
        }
        String newSchema = this.scheme == null ? url.scheme : this.scheme;
        String newUserInfo = this.userInfo == null ? url.userInfo : this.userInfo;
        String newHost = this.host == null ? url.host : this.host;
        Integer newPort = this.port == null ? url.port : this.port;
        String newPath = this.path == null ? url.path : this.path;
        String newRef = this.ref == null ? url.ref : this.ref;
        return new ForestURL(newSchema, newUserInfo, newHost, newPort, newPath, newRef);
    }

    public ForestURL setBaseURL(ForestURL baseURL) {
        String baseSchema = "http";
        String baseUserInfo = null;
        String baseHost = "localhost";
        int basePort = -1;
        String basePath = null;
        boolean portChange = false;
        if (baseURL != null) {
            if (baseURL.scheme != null) {
                baseSchema = baseURL.scheme;
            }
            if (baseURL.userInfo != null) {
                baseUserInfo = baseURL.userInfo;
            }
            if (baseURL.host != null) {
                baseHost = baseURL.host;
            }
            if (URLUtils.isNotNonePort(baseURL.port)) {
                basePort = baseURL.port;
            }
            if (baseURL.path != null) {
                basePath = baseURL.path;
            }
        }
        boolean needBasePath = false;
        if (this.scheme == null) {
            portChange = true;
            this.setScheme(baseSchema);
            needBasePath = true;
        }
        if (this.userInfo == null) {
            this.userInfo = baseUserInfo;
        }
        if (this.host == null) {
            this.host = baseHost;
            needBasePath = true;
        }
        if (portChange && URLUtils.isNonePort(this.port)) {
            this.port = basePort;
        }
        if (StringUtils.isNotBlank(this.path) && this.path.charAt(0) != '/') {
            this.path = '/' + this.path;
        }
        if (needBasePath && StringUtils.isNotBlank(basePath)) {
            if (basePath.charAt(basePath.length() - 1) == '/') {
                basePath = basePath.substring(0, basePath.length() - 1);
            }
            this.path = StringUtils.isEmpty(this.path) ? basePath : basePath + this.path;
        }
        this.needRegenerateUrl();
        return this;
    }

    public ForestURL mergeAddress() {
        if (this.address != null) {
            String originHost = this.host;
            if (StringUtils.isEmpty(this.scheme)) {
                this.scheme = this.address.getScheme();
                this.refreshSSL();
            }
            if (StringUtils.isEmpty(this.host)) {
                this.host = this.address.getHost();
            }
            if (URLUtils.isNonePort(this.port) && StringUtils.isEmpty(originHost)) {
                this.port = this.address.getPort();
            }
            if (StringUtils.isEmpty(this.userInfo)) {
                this.userInfo = this.address.getUserInfo();
            }
            if (StringUtils.isEmpty(this.basePath)) {
                this.setBasePath(this.address.getBasePath(), false);
            }
            this.needRegenerateUrl();
        }
        return this;
    }

    public ForestURL checkAndComplete() {
        String oldUrl = this.getOriginalUrl();
        if (StringUtils.isEmpty(this.scheme)) {
            this.setScheme(this.ssl ? "https" : "http");
        }
        if (StringUtils.isEmpty(this.host)) {
            this.setHost("localhost");
            if (URLUtils.isNonePort(this.port)) {
                log.warn("[Forest] Invalid url '" + oldUrl + "'. But an valid url must start width 'http://' or 'https://'. Convert this url to '" + this.toURLString() + "' automatically!");
            } else {
                log.warn("[Forest] Invalid url '" + oldUrl + "'. Host is empty. Convert this url to '" + this.toURLString() + "' automatically!");
            }
        }
        return this;
    }
}

