/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestHeader;
import com.dtflys.forest.http.ForestHeaderMap;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.HasURL;
import com.dtflys.forest.http.Lazy;

public class LazyHeader
implements ForestHeader<LazyHeader, Lazy<?>> {
    private final ForestHeaderMap headerMap;
    private final String name;
    private Lazy<?> lazyValue;

    public LazyHeader(ForestHeaderMap headerMap, String name, Lazy<?> lazyValue) {
        this.headerMap = headerMap;
        this.name = name;
        this.lazyValue = lazyValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        HasURL hasURL = this.headerMap.getHasURL();
        if (!(hasURL instanceof ForestRequest)) {
            throw new ForestRuntimeException("the request of header[name=" + this.name + "] dose not exist");
        }
        ForestRequest request = (ForestRequest)hasURL;
        if (this.lazyValue == null) {
            throw new ForestRuntimeException("the lazy value of header[name=" + this.name + "] is null");
        }
        Object ret = this.lazyValue.eval(request);
        if (ret == null) {
            return null;
        }
        return String.valueOf(ret);
    }

    @Override
    public LazyHeader setValue(Lazy<?> lazyValue) {
        this.lazyValue = lazyValue;
        return this;
    }

    @Override
    public LazyHeader clone(ForestHeaderMap headerMap) {
        return new LazyHeader(headerMap, this.name, this.lazyValue);
    }
}

