/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http;

import com.dtflys.forest.http.AbstractQueryParameter;
import com.dtflys.forest.http.ForestQueryMap;
import com.dtflys.forest.http.Lazy;

public class SimpleQueryParameter
extends AbstractQueryParameter<SimpleQueryParameter> {
    private final String name;
    private Object value;

    public SimpleQueryParameter(ForestQueryMap queries, String name, Object value) {
        this(queries, name, value, false, null);
    }

    public SimpleQueryParameter(ForestQueryMap queries, String name, Object value, Boolean urlencoded, String charset) {
        this(queries, name, value, false, urlencoded, charset);
    }

    public SimpleQueryParameter(ForestQueryMap queries, String name, Object value, boolean fromUrl, Boolean urlencoded, String charset) {
        super(queries, fromUrl);
        this.name = name;
        this.value = value;
        if (urlencoded != null) {
            this.urlencoded = urlencoded;
        } else if (fromUrl) {
            this.urlencoded = false;
        }
        this.charset = charset;
    }

    public SimpleQueryParameter(ForestQueryMap queries, String name) {
        this(queries, name, null, false, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Object getOriginalValue() {
        return this.value;
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Lazy) {
            return ((Lazy)this.value).eval(this.queries.request);
        }
        return this.value;
    }

    @Override
    public SimpleQueryParameter setValue(Object value) {
        this.value = value;
        return this;
    }
}

