/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.body.BinaryRequestBody;
import com.dtflys.forest.http.body.SupportFormUrlEncoded;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.RequestNameValue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;

public class ByteArrayRequestBody
extends BinaryRequestBody
implements SupportFormUrlEncoded {
    private byte[] byteArray;

    public ByteArrayRequestBody(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    public void setByteArray(byte[] byteArray) {
        this.byteArray = byteArray;
    }

    @Override
    public byte[] getByteArray() {
        return this.byteArray;
    }

    @Override
    InputStream getInputStream() {
        return new ByteArrayInputStream(this.byteArray);
    }

    @Override
    public ForestDataType getDefaultBodyType() {
        return ForestDataType.BINARY;
    }

    @Override
    public List<RequestNameValue> getNameValueList(ForestRequest request) {
        String str = new String(this.byteArray);
        LinkedList<RequestNameValue> nameValueList = new LinkedList<RequestNameValue>();
        nameValueList.add(new RequestNameValue(str, 2));
        return nameValueList;
    }

    @Override
    public ByteArrayRequestBody clone() {
        ByteArrayRequestBody newBody = new ByteArrayRequestBody(this.byteArray);
        newBody.setDefaultValue(this.getDefaultValue());
        return newBody;
    }

    public String toString() {
        return new String(this.byteArray, StandardCharsets.UTF_8);
    }
}

