/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.body.BinaryRequestBody;
import com.dtflys.forest.utils.ForestDataType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class FileRequestBody
extends BinaryRequestBody {
    private File file;

    public FileRequestBody(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Override
    public byte[] getByteArray() {
        try {
            return FileUtils.readFileToByteArray((File)this.file);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    @Override
    InputStream getInputStream() {
        try {
            return FileUtils.openInputStream((File)this.file);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    @Override
    public ForestDataType getDefaultBodyType() {
        return ForestDataType.BINARY;
    }

    @Override
    public FileRequestBody clone() {
        FileRequestBody newBody = new FileRequestBody(this.file);
        newBody.setDefaultValue(this.getDefaultValue());
        return newBody;
    }
}

