/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.converter.json.ForestJsonConverter;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.Lazy;
import com.dtflys.forest.http.body.SupportFormUrlEncoded;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.RequestNameValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class ObjectRequestBody
extends ForestRequestBody
implements SupportFormUrlEncoded {
    private Object object;

    public ObjectRequestBody(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public String toString() {
        return String.valueOf(this.object);
    }

    @Override
    public byte[] getByteArray() {
        Object obj = this.object;
        if (obj == null) {
            return new byte[0];
        }
        if (obj instanceof Lazy) {
            obj = ((Lazy)obj).eval(this.body.getRequest());
        }
        if (obj instanceof byte[]) {
            return (byte[])this.object;
        }
        try {
            if (obj instanceof InputStream) {
                return IOUtils.toByteArray((InputStream)((InputStream)this.object));
            }
            if (obj instanceof File) {
                return FileUtils.readFileToByteArray((File)((File)this.object));
            }
            if (obj instanceof Reader) {
                return IOUtils.toByteArray((Reader)((Reader)this.object));
            }
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
        return this.toString().getBytes();
    }

    @Override
    public ForestDataType getDefaultBodyType() {
        return ForestDataType.FORM;
    }

    @Override
    public List<RequestNameValue> getNameValueList(ForestRequest request) {
        LinkedList<RequestNameValue> nameValueList = new LinkedList<RequestNameValue>();
        if (this.object == null) {
            return nameValueList;
        }
        ForestJsonConverter jsonConverter = request.getConfiguration().getJsonConverter();
        Object obj = this.object;
        if (obj instanceof Lazy) {
            obj = ((Lazy)obj).eval(this.body.getRequest());
        }
        Map<String, Object> map = jsonConverter.convertObjectToMap(obj, request);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            nameValueList.add(new RequestNameValue(entry.getKey(), entry.getValue(), 2));
        }
        return nameValueList;
    }

    @Override
    public ObjectRequestBody clone() {
        ObjectRequestBody newBody = new ObjectRequestBody(this.object);
        newBody.setDefaultValue(this.getDefaultValue());
        return newBody;
    }
}

