/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.http.body;

import com.dtflys.forest.http.ForestRequestBody;
import com.dtflys.forest.http.body.ByteArrayRequestBody;
import com.dtflys.forest.http.body.FileRequestBody;
import com.dtflys.forest.http.body.InputStreamRequestBody;
import com.dtflys.forest.http.body.ObjectRequestBody;
import com.dtflys.forest.http.body.StringRequestBody;
import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class RequestBodyBuilder<T, B extends ForestRequestBody, D extends RequestBodyBuilder> {
    private static final Map<Class, RequestBodyBuilder> bodyBuilderMap = new LinkedHashMap<Class, RequestBodyBuilder>();

    public static void registerBodyBuilder(Class clazz, RequestBodyBuilder bodyBuilder) {
        bodyBuilderMap.put(clazz, bodyBuilder);
    }

    public static boolean canBuild(Class clazz) {
        RequestBodyBuilder builder = RequestBodyBuilder.type(clazz);
        return builder != null;
    }

    public static boolean canBuild(Object obj) {
        return RequestBodyBuilder.canBuild(obj.getClass());
    }

    public static RequestBodyBuilder type(Class clazz) {
        if (clazz == null) {
            return null;
        }
        RequestBodyBuilder builder = bodyBuilderMap.get(clazz);
        if (builder == null) {
            for (Class keyClass : bodyBuilderMap.keySet()) {
                if (!keyClass.isAssignableFrom(clazz)) continue;
                return bodyBuilderMap.get(keyClass);
            }
        }
        return builder;
    }

    public abstract B build(T var1, String var2);

    static {
        RequestBodyBuilder.registerBodyBuilder(CharSequence.class, new StringRequestBodyBuilder());
        RequestBodyBuilder.registerBodyBuilder(String.class, new StringRequestBodyBuilder());
        RequestBodyBuilder.registerBodyBuilder(File.class, new FileRequestBodyBuilder());
        RequestBodyBuilder.registerBodyBuilder(byte[].class, new ByteArrayRequestBodyBuilder());
        RequestBodyBuilder.registerBodyBuilder(InputStream.class, new InputStreamBodyBuilder());
        RequestBodyBuilder.registerBodyBuilder(Object.class, new ObjectRequestBodyBuilder());
    }

    public static class StringRequestBodyBuilder
    extends RequestBodyBuilder<String, StringRequestBody, StringRequestBodyBuilder> {
        @Override
        public StringRequestBody build(String data, String defaultValue) {
            if (data == null) {
                return null;
            }
            StringRequestBody body = new StringRequestBody(data);
            body.setDefaultValue(defaultValue);
            return body;
        }
    }

    public static class FileRequestBodyBuilder
    extends RequestBodyBuilder<File, FileRequestBody, StringRequestBodyBuilder> {
        @Override
        public FileRequestBody build(File data, String defaultValue) {
            if (data == null) {
                return null;
            }
            FileRequestBody body = new FileRequestBody(data);
            body.setDefaultValue(defaultValue);
            return body;
        }
    }

    public static class ByteArrayRequestBodyBuilder
    extends RequestBodyBuilder<byte[], ByteArrayRequestBody, StringRequestBodyBuilder> {
        @Override
        public ByteArrayRequestBody build(byte[] data, String defaultValue) {
            if (data == null) {
                return null;
            }
            ByteArrayRequestBody body = new ByteArrayRequestBody(data);
            body.setDefaultValue(defaultValue);
            return body;
        }
    }

    public static class InputStreamBodyBuilder
    extends RequestBodyBuilder<InputStream, InputStreamRequestBody, StringRequestBodyBuilder> {
        @Override
        public InputStreamRequestBody build(InputStream data, String defaultValue) {
            if (data == null) {
                return null;
            }
            InputStreamRequestBody body = new InputStreamRequestBody(data);
            body.setDefaultValue(defaultValue);
            return body;
        }
    }

    public static class ObjectRequestBodyBuilder
    extends RequestBodyBuilder<Object, ObjectRequestBody, StringRequestBodyBuilder> {
        @Override
        public ObjectRequestBody build(Object data, String defaultValue) {
            if (data == null) {
                return null;
            }
            ObjectRequestBody body = new ObjectRequestBody(data);
            body.setDefaultValue(defaultValue);
            return body;
        }
    }
}

