/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.interceptor;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.Interceptor;
import com.dtflys.forest.interceptor.InterceptorChain;
import com.dtflys.forest.interceptor.InterceptorFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultInterceptorFactory
implements InterceptorFactory {
    protected final Map<Class, Interceptor> INTERCEPTOR_CACHE = new ConcurrentHashMap<Class, Interceptor>();
    protected InterceptorChain interceptorChain = new InterceptorChain();

    @Override
    public InterceptorChain getInterceptorChain() {
        return this.interceptorChain;
    }

    @Override
    public <T extends Interceptor> T getInterceptor(Class<T> clazz) {
        return (T)this.INTERCEPTOR_CACHE.computeIfAbsent(clazz, key -> this.createInterceptor((Class)key));
    }

    protected <T extends Interceptor> Interceptor createInterceptor(Class<T> clazz) {
        try {
            return (Interceptor)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new ForestRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
    }
}

