/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.parameter;

import com.dtflys.forest.annotation.DataFile;
import com.dtflys.forest.annotation.ProtobufBody;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.lifecycles.parameter.AbstractBodyLifeCycle;
import com.dtflys.forest.mapping.MappingParameter;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.reflection.MetaRequest;
import com.dtflys.forest.utils.ForestDataType;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.Parameter;

public class ProtobufBodyLifeCycle
extends AbstractBodyLifeCycle<ProtobufBody> {
    @Override
    public void onParameterInitialized(ForestMethod method, MappingParameter parameter, ProtobufBody annotation) {
        String contentTypeStr;
        super.onParameterInitialized(method, parameter, annotation);
        MetaRequest metaRequest = method.getMetaRequest();
        String methodName = ProtobufBodyLifeCycle.methodName(method);
        if (metaRequest == null) {
            throw new ForestRuntimeException("[Forest] method '" + methodName + "' has not bind a Forest request annotation. Hence the annotation @BinaryBody cannot be bind on a parameter in this method.");
        }
        boolean hasDataFileAnn = false;
        for (Parameter param : method.getMethod().getParameters()) {
            DataFile dataFileAnn = param.getAnnotation(DataFile.class);
            if (dataFileAnn == null) continue;
            hasDataFileAnn = true;
            break;
        }
        if (StringUtils.isBlank(contentTypeStr = metaRequest.getContentType()) && !hasDataFileAnn) {
            metaRequest.setContentType("application/x-protobuf");
        }
        if (metaRequest.getBodyType() == null) {
            metaRequest.setBodyType(ForestDataType.PROTOBUF);
        }
        parameter.setTarget(2);
    }

    private static String methodName(ForestMethod method) {
        return method.getMethod().toGenericString();
    }

    @Override
    public boolean beforeExecute(ForestRequest request) {
        String contentType = request.getContentType();
        if (StringUtils.isBlank(contentType)) {
            request.setContentType("application/x-protobuf");
        }
        return true;
    }
}

