/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.lifecycles.proxy;

import com.dtflys.forest.annotation.HTTPProxy;
import com.dtflys.forest.callback.HTTPProxySource;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestProxy;
import com.dtflys.forest.http.ForestProxyType;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.lifecycles.MethodAnnotationLifeCycle;
import com.dtflys.forest.mapping.MappingTemplate;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.HeaderUtils;
import com.dtflys.forest.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public class HTTPProxyLifeCycle
implements MethodAnnotationLifeCycle<HTTPProxy, Object> {
    private static final String PARAM_KEY_HTTP_PROXY_SOURCE = "__http_proxy_source";
    private static final String PARAM_KEY_HTTP_PROXY = "__http_proxy";

    @Override
    public void onInvokeMethod(ForestRequest request, ForestMethod method, Object[] args) {
        ForestProxyType type = (ForestProxyType)((Object)this.getAttribute(request, "type"));
        String hostStr = (String)this.getAttribute(request, "host");
        String portStr = (String)this.getAttribute(request, "port");
        String usernameStr = (String)this.getAttribute(request, "username");
        String passwordStr = (String)this.getAttribute(request, "password");
        String[] headersStr = (String[])this.getAttribute(request, "headers");
        MappingTemplate hostTemplate = method.makeTemplate(HTTPProxy.class, "host", hostStr);
        MappingTemplate portTemplate = method.makeTemplate(HTTPProxy.class, "port", portStr);
        MappingTemplate usernameTemplate = method.makeTemplate(HTTPProxy.class, "username", usernameStr);
        MappingTemplate passwordTemplate = method.makeTemplate(HTTPProxy.class, "password", passwordStr);
        Object httpProxySource = request.getMethod().getExtensionParameterValue(PARAM_KEY_HTTP_PROXY_SOURCE);
        MappingTemplate[] headersTemplates = (MappingTemplate[])Arrays.stream(headersStr).map(headerStr -> method.makeTemplate((Class<? extends Annotation>)HTTPProxy.class, "headers", (String)headerStr)).toArray(MappingTemplate[]::new);
        String host = hostTemplate.render(args);
        String username = null;
        String password = null;
        if (usernameTemplate != null) {
            username = usernameTemplate.render(args);
        }
        if (passwordTemplate != null) {
            password = passwordTemplate.render(args);
        }
        int port = 80;
        if (StringUtils.isBlank(host)) {
            if (httpProxySource != null && httpProxySource instanceof HTTPProxySource) {
                request.setProxy(((HTTPProxySource)httpProxySource).getProxy(request));
                return;
            }
            throw new ForestRuntimeException("[Forest] Proxy host cannot be empty!");
        }
        if (StringUtils.isNotBlank(portStr)) {
            portStr = portTemplate.render(args);
            try {
                port = Integer.parseInt(portStr);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ForestProxy proxy = new ForestProxy(type, host, port);
        if (StringUtils.isNotEmpty(username)) {
            proxy.setUsername(username);
        }
        if (StringUtils.isNotEmpty(password)) {
            proxy.setPassword(password);
        }
        if (headersTemplates != null && headersTemplates.length > 0) {
            HeaderUtils.addHeaders(proxy, headersTemplates, args);
        }
        request.setProxy(proxy);
    }

    @Override
    public boolean beforeExecute(ForestRequest request) {
        return true;
    }

    @Override
    public void onMethodInitialized(ForestMethod method, HTTPProxy annotation) {
        Class<? extends HTTPProxySource> clazz = annotation.source();
        if (clazz != null && !clazz.isInterface()) {
            HTTPProxySource proxySource = method.getConfiguration().getForestObject(clazz);
            method.setExtensionParameterValue(PARAM_KEY_HTTP_PROXY_SOURCE, proxySource);
        }
        method.setExtensionParameterValue(PARAM_KEY_HTTP_PROXY, annotation);
    }
}

