/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.mapping;

import com.dtflys.forest.converter.ForestConverter;
import com.dtflys.forest.filter.Filter;
import com.dtflys.forest.filter.FilterChain;
import com.dtflys.forest.utils.StringUtils;

public class MappingParameter {
    public static final int TARGET_UNKNOWN = 0;
    public static final int TARGET_QUERY = 1;
    public static final int TARGET_BODY = 2;
    public static final int TARGET_HEADER = 3;
    protected final Class<?> type;
    protected Integer index;
    protected String name;
    protected String map;
    protected int target = 0;
    private boolean objectProperties = false;
    private boolean isJsonParam = false;
    private boolean isUrlEncode = false;
    private String charset;
    private String partContentType;
    private String defaultValue;
    private String jsonParamName;
    private FilterChain filterChain = new FilterChain();

    public MappingParameter(Class type) {
        this.type = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMap() {
        return this.map;
    }

    public void setMap(String map) {
        this.map = map;
    }

    public boolean isUnknownTarget() {
        return this.target == 0;
    }

    public boolean isQuery() {
        return this.target == 1;
    }

    public boolean isBody() {
        return this.target == 2;
    }

    public boolean isHeader() {
        return this.target == 3;
    }

    public static boolean isUnknownTarget(int target) {
        return target == 0;
    }

    public static boolean isHeader(int target) {
        return target == 3;
    }

    public static boolean isBody(int target) {
        return target == 2;
    }

    public static boolean isQuery(int target) {
        return target == 1;
    }

    public int getTarget() {
        return this.target;
    }

    public Object getConvertedDefaultValue(ForestConverter converter) {
        if (StringUtils.isEmpty(this.defaultValue)) {
            return null;
        }
        if (CharSequence.class.isAssignableFrom(this.type) && this.defaultValue instanceof CharSequence) {
            return this.defaultValue;
        }
        return converter.convertToJavaObject(this.defaultValue, this.type);
    }

    public void setTarget(int target) {
        this.target = target;
    }

    public boolean isObjectProperties() {
        return this.objectProperties;
    }

    public void setObjectProperties(boolean objectProperties) {
        this.objectProperties = objectProperties;
    }

    public boolean isJsonParam() {
        return this.isJsonParam;
    }

    public void setJsonParam(boolean jsonParam) {
        this.isJsonParam = jsonParam;
    }

    public boolean isUrlEncode() {
        return this.isUrlEncode;
    }

    public void setUrlEncode(boolean urlEncode) {
        this.isUrlEncode = urlEncode;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getPartContentType() {
        return this.partContentType;
    }

    public void setPartContentType(String partContentType) {
        this.partContentType = partContentType;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getJsonParamName() {
        return this.jsonParamName;
    }

    public void setJsonParamName(String jsonParamName) {
        this.jsonParamName = jsonParamName;
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public void addFilter(Filter filter) {
        this.filterChain.addFilter(filter);
    }
}

