/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.mapping;

import com.dtflys.forest.config.VariableScope;
import com.dtflys.forest.exceptions.ForestVariableUndefinedException;
import com.dtflys.forest.mapping.MappingExpr;
import com.dtflys.forest.mapping.MappingVariable;
import com.dtflys.forest.mapping.Token;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.utils.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class MappingReference
extends MappingExpr {
    private String name;
    private static final Set<String> ITERATE_VARS = new HashSet<String>();

    public MappingReference(ForestMethod<?> forestMethod, VariableScope variableScope, String name) {
        super(forestMethod, Token.REF);
        this.variableScope = variableScope;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object render(Object[] args) {
        MappingVariable variable = this.variableScope.getVariable(this.name);
        if (variable != null) {
            return args[variable.getIndex()];
        }
        if (!this.variableScope.isVariableDefined(this.name)) {
            throw new ForestVariableUndefinedException(this.name);
        }
        return this.variableScope.getVariableValue(this.name, this.forestMethod);
    }

    @Override
    public boolean isIterateVariable() {
        if (StringUtils.isEmpty(this.name)) {
            return false;
        }
        return ITERATE_VARS.contains(this.name);
    }

    public String toString() {
        return "[Refer: " + this.name + "]";
    }

    static {
        ITERATE_VARS.add("_index");
        ITERATE_VARS.add("_key");
    }
}

