/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.multipart;

import com.dtflys.forest.exceptions.ForestNoFileNameException;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class ByteArrayMultipart
extends ForestMultipart<byte[], ByteArrayMultipart> {
    private byte[] bytes;

    @Override
    public String getOriginalFileName() {
        if (StringUtils.isBlank(this.fileName)) {
            throw new ForestNoFileNameException(byte[].class);
        }
        return this.fileName;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public ByteArrayMultipart setData(byte[] data) {
        this.bytes = data;
        return this;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public long getSize() {
        return this.bytes.length;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }
}

