/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.multipart;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.multipart.ForestMultipart;
import com.dtflys.forest.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public class FileMultipart
extends ForestMultipart<File, FileMultipart> {
    private File file;

    @Override
    public String getOriginalFileName() {
        if (StringUtils.isNotBlank(this.fileName)) {
            return this.fileName;
        }
        return this.file.getName();
    }

    @Override
    public FileMultipart setData(File data) {
        this.file = data;
        return this;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return FileUtils.openInputStream((File)this.file);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }

    @Override
    public long getSize() {
        return this.file.length();
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public File getFile() {
        return this.file;
    }
}

