/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.multipart;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public abstract class ForestMultipart<T, SELF extends ForestMultipart<T, SELF>> {
    protected String name;
    protected String fileName;
    protected String contentType;

    public String getName() {
        return this.name;
    }

    public SELF setName(String name) {
        this.name = name;
        return (SELF)this;
    }

    public SELF setFileName(String fileName) {
        this.fileName = fileName;
        return (SELF)this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public SELF setContentType(String contentType) {
        this.contentType = contentType;
        return (SELF)this;
    }

    public abstract SELF setData(T var1);

    public abstract String getOriginalFileName();

    public abstract InputStream getInputStream();

    public abstract long getSize();

    public abstract boolean isFile();

    public abstract File getFile();

    public byte[] getBytes() {
        InputStream inputStream = this.getInputStream();
        try {
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new ForestRuntimeException(e);
        }
    }
}

