/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.proxy;

import com.dtflys.forest.annotation.BaseLifeCycle;
import com.dtflys.forest.annotation.BaseURL;
import com.dtflys.forest.annotation.MethodLifeCycle;
import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.config.VariableScope;
import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.interceptor.InterceptorFactory;
import com.dtflys.forest.lifecycles.BaseAnnotationLifeCycle;
import com.dtflys.forest.logging.LogConfiguration;
import com.dtflys.forest.mapping.MappingVariable;
import com.dtflys.forest.proxy.ProxyFactory;
import com.dtflys.forest.reflection.ForestMethod;
import com.dtflys.forest.reflection.MetaRequest;
import com.dtflys.forest.utils.MethodHandlesUtil;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceProxyHandler<T>
implements InvocationHandler,
VariableScope {
    private static final Map<String, NonParamsInvocation> NON_PARAMS_INVOCATION_MAP = new HashMap<String, NonParamsInvocation>();
    private final ForestConfiguration configuration;
    private final ProxyFactory proxyFactory;
    private final Class<T> interfaceClass;
    private final Map<Method, ForestMethod> forestMethodMap = new HashMap<Method, ForestMethod>();
    private final MetaRequest baseMetaRequest = new MetaRequest();
    private final InterceptorFactory interceptorFactory;
    private LogConfiguration baseLogConfiguration;
    private final MethodHandles.Lookup defaultMethodLookup;
    private final List<Annotation> baseAnnotations = new LinkedList<Annotation>();

    private static void registerNonParamsInvocation(String methodName, NonParamsInvocation invocation) {
        NON_PARAMS_INVOCATION_MAP.put(methodName, invocation);
    }

    private static NonParamsInvocation getNonParamsInvocation(String methodName) {
        return NON_PARAMS_INVOCATION_MAP.get(methodName);
    }

    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public InterfaceProxyHandler(ForestConfiguration configuration, ProxyFactory proxyFactory, Class<T> interfaceClass) {
        this.configuration = configuration;
        this.proxyFactory = proxyFactory;
        this.interfaceClass = interfaceClass;
        this.interceptorFactory = configuration.getInterceptorFactory();
        try {
            this.defaultMethodLookup = MethodHandlesUtil.lookup(interfaceClass);
        }
        catch (Throwable e) {
            throw new ForestRuntimeException(e);
        }
        this.prepareBaseInfo();
        this.initMethods();
    }

    private void prepareBaseInfo() {
        this.prepareBaseInfo(this.interfaceClass);
    }

    public Class<T> getInterfaceClass() {
        return this.interfaceClass;
    }

    public List<ForestMethod> getForestMethods() {
        return new ArrayList<ForestMethod>(this.forestMethodMap.values());
    }

    private void processBaseAnnotation(Class parentAnnType, Annotation[] annotations) {
        for (int i = 0; i < annotations.length; ++i) {
            Class<? extends BaseAnnotationLifeCycle> interceptorClass;
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annType = annotation.annotationType();
            String annName = annType.getName();
            if (annName.startsWith("java.") || annName.startsWith("javax.") || annName.startsWith("kotlin.")) continue;
            Annotation[] subAnnotations = annType.getAnnotations();
            if (parentAnnType != null && !annType.equals(parentAnnType)) {
                this.processBaseAnnotation(annType, subAnnotations);
            }
            if (annotation instanceof BaseURL) {
                BaseURL baseURLAnn = (BaseURL)annotation;
                String value = baseURLAnn.value();
                if (value == null || value.trim().length() == 0) continue;
                String baseURL = value.trim();
                this.baseMetaRequest.setUrl(baseURL);
                continue;
            }
            BaseLifeCycle baseLifeCycle = annotation.annotationType().getAnnotation(BaseLifeCycle.class);
            MethodLifeCycle methodLifeCycle = annotation.annotationType().getAnnotation(MethodLifeCycle.class);
            if (baseLifeCycle == null && methodLifeCycle == null) continue;
            if (baseLifeCycle != null && (interceptorClass = baseLifeCycle.value()) != null) {
                BaseAnnotationLifeCycle baseInterceptor = this.interceptorFactory.getInterceptor(interceptorClass);
                baseInterceptor.onProxyHandlerInitialized(this, annotation);
            }
            this.baseAnnotations.add(annotation);
        }
    }

    private void prepareBaseInfo(Class<?> clazz) {
        Class<?>[] superClasses;
        for (Class<?> superClass : superClasses = clazz.getInterfaces()) {
            this.prepareBaseInfo(superClass);
        }
        Annotation[] annotations = clazz.getAnnotations();
        this.processBaseAnnotation(null, annotations);
    }

    private void initMethods() {
        this.initMethods(this.interfaceClass);
    }

    private void initMethods(Class<?> clazz) {
        Class<?>[] superClasses;
        for (Class<?> superClass : superClasses = clazz.getInterfaces()) {
            this.initMethods(superClass);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.isDefault()) continue;
            ForestMethod forestMethod = new ForestMethod(this, this.configuration, method);
            this.forestMethodMap.put(method, forestMethod);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (method.isDefault()) {
            return this.invokeDefaultMethod(proxy, method, args);
        }
        ForestMethod forestMethod = this.forestMethodMap.get(method);
        if (forestMethod == null) {
            NonParamsInvocation invocation;
            if ((args == null || args.length == 0) && (invocation = InterfaceProxyHandler.getNonParamsInvocation(methodName)) != null) {
                return invocation.invoke(this, proxy);
            }
            if (args != null && args.length == 1) {
                if ("equals".equals(methodName)) {
                    Object obj = args[0];
                    if (Proxy.isProxyClass(obj.getClass())) {
                        InvocationHandler h1 = Proxy.getInvocationHandler(proxy);
                        InvocationHandler h2 = Proxy.getInvocationHandler(obj);
                        return h1.equals(h2);
                    }
                    return false;
                }
                if ("wait".equals(methodName) && args[0] instanceof Long) {
                    proxy.wait((Long)args[0]);
                }
            }
            if (args != null && args.length == 2 && args[0] instanceof Long && args[1] instanceof Integer && "wait".equals(methodName)) {
                proxy.wait((Long)args[0], (Integer)args[1]);
            }
            throw new NoSuchMethodError(method.getName());
        }
        return forestMethod.invoke(args);
    }

    private Object invokeDefaultMethod(Object proxy, Method method, Object[] args) throws Throwable {
        return this.defaultMethodLookup.findSpecial(this.interfaceClass, method.getName(), MethodType.methodType(method.getReturnType(), method.getParameterTypes()), this.interfaceClass).bindTo(proxy).invokeWithArguments(args);
    }

    public MetaRequest getBaseMetaRequest() {
        return this.baseMetaRequest;
    }

    @Override
    public boolean isVariableDefined(String name) {
        return this.configuration.isVariableDefined(name);
    }

    @Override
    public Object getVariableValue(String name) {
        return this.getVariableValue(name, null);
    }

    @Override
    public Object getVariableValue(String name, ForestMethod method) {
        return this.configuration.getVariableValue(name, method);
    }

    public List<Annotation> getBaseAnnotations() {
        return this.baseAnnotations;
    }

    @Override
    public MappingVariable getVariable(String name) {
        return null;
    }

    @Override
    public ForestConfiguration getConfiguration() {
        return this.configuration;
    }

    public LogConfiguration getBaseLogConfiguration() {
        return this.baseLogConfiguration;
    }

    public void setBaseLogConfiguration(LogConfiguration baseLogConfiguration) {
        this.baseLogConfiguration = baseLogConfiguration;
    }

    static {
        InterfaceProxyHandler.registerNonParamsInvocation("toString", (handler, proxy) -> "{Forest Proxy Object of " + handler.interfaceClass.getName() + "}");
        InterfaceProxyHandler.registerNonParamsInvocation("getClass", (handler, proxy) -> proxy.getClass());
        InterfaceProxyHandler.registerNonParamsInvocation("hashCode", (handler, proxy) -> proxy.hashCode());
        InterfaceProxyHandler.registerNonParamsInvocation("notify", (handler, proxy) -> {
            proxy.notify();
            return null;
        });
        InterfaceProxyHandler.registerNonParamsInvocation("notifyAll", (handler, proxy) -> {
            proxy.notifyAll();
            return null;
        });
        InterfaceProxyHandler.registerNonParamsInvocation("wait", (handler, proxy) -> {
            proxy.wait();
            return null;
        });
        InterfaceProxyHandler.registerNonParamsInvocation("getProxyHandler", (handler, proxy) -> handler);
    }

    private static interface NonParamsInvocation {
        public Object invoke(InterfaceProxyHandler<?> var1, Object var2) throws Throwable;
    }
}

