/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.proxy;

import com.dtflys.forest.config.ForestConfiguration;
import com.dtflys.forest.proxy.ForestClientProxy;
import com.dtflys.forest.proxy.InterfaceProxyHandler;
import com.dtflys.forest.reflection.ForestMethod;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProxyFactory<T> {
    private ForestConfiguration configuration;
    private Class<T> interfaceClass;
    private InterfaceProxyHandler<T> interfaceProxyHandler;

    public ProxyFactory(ForestConfiguration configuration, Class<T> interfaceClass) {
        this.configuration = configuration;
        this.interfaceClass = interfaceClass;
    }

    public Class<T> getInterfaceClass() {
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<T> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public List<ForestMethod> getForestMethods() {
        if (this.interfaceProxyHandler == null) {
            return new ArrayList<ForestMethod>();
        }
        return this.interfaceProxyHandler.getForestMethods();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T createInstance() {
        Object instance = this.configuration.getInstanceCache().get(this.interfaceClass);
        boolean cacheEnabled = this.configuration.isCacheEnabled();
        if (cacheEnabled && instance != null) {
            return (T)instance;
        }
        Map<Class, Object> map = this.configuration.getInstanceCache();
        synchronized (map) {
            instance = this.configuration.getInstanceCache().get(this.interfaceClass);
            if (cacheEnabled && instance != null) {
                return (T)instance;
            }
            this.interfaceProxyHandler = new InterfaceProxyHandler<T>(this.configuration, this, this.interfaceClass);
            instance = Proxy.newProxyInstance(this.interfaceClass.getClassLoader(), new Class[]{this.interfaceClass, ForestClientProxy.class}, this.interfaceProxyHandler);
            if (cacheEnabled) {
                this.configuration.getInstanceCache().put(this.interfaceClass, instance);
            }
            return (T)instance;
        }
    }
}

