/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.reflection;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropWrapper {
    private static final Object[] GETTER_ARGS = new Object[0];
    private final String name;
    Field field;
    Method getter;
    Method setter;

    public PropWrapper(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public Object getValue(Object instance) {
        if (this.getter == null) {
            if (this.field != null) {
                try {
                    return this.field.get(instance);
                }
                catch (IllegalAccessException e) {
                    throw new ForestRuntimeException(e);
                }
            }
            throw new ForestRuntimeException("The property '" + this.name + "' has not getter method or accessible field");
        }
        try {
            return this.getter.invoke(instance, GETTER_ARGS);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ForestRuntimeException(e);
        }
    }

    public void setValue(Object instance, Object value) {
        if (this.setter == null) {
            if (this.field != null) {
                try {
                    this.field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    throw new ForestRuntimeException(e);
                }
            }
            throw new ForestRuntimeException("The property '" + this.name + "' has not setter method or accessible field");
        }
        try {
            this.setter.invoke(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new ForestRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new ForestRuntimeException(e);
        }
    }
}

