/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.reflection;

import com.dtflys.forest.reflection.PropWrapper;
import com.dtflys.forest.utils.NameUtils;
import com.dtflys.forest.utils.ReflectUtils;
import com.dtflys.forest.utils.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TypeWrapper {
    private static final Map<Class<?>, TypeWrapper> TYPE_CACHE = new ConcurrentHashMap();
    private final Class<?> clazz;
    private final Map<String, PropWrapper> props = new LinkedHashMap<String, PropWrapper>();

    public static TypeWrapper get(Class<?> clazz) {
        TypeWrapper typeWrapper = TYPE_CACHE.get(clazz);
        if (typeWrapper == null) {
            typeWrapper = new TypeWrapper(clazz);
            TYPE_CACHE.put(clazz, typeWrapper);
        }
        return typeWrapper;
    }

    private TypeWrapper(Class<?> clazz) {
        this.clazz = clazz;
        this.init();
    }

    private void init() {
        Field[] fields;
        Method[] methods = ReflectUtils.getMethods(this.clazz);
        LinkedHashMap<String, PropWrapper> newProps = new LinkedHashMap<String, PropWrapper>();
        for (Method method : methods) {
            PropWrapper prop2;
            String name;
            String methodName = method.getName();
            int paramCount = method.getParameterCount();
            if (paramCount == 0 && NameUtils.isGetter(methodName)) {
                name = NameUtils.propNameFromGetter(methodName);
                if (!StringUtils.isNotEmpty(name)) continue;
                prop2 = (PropWrapper)newProps.get(name);
                if (prop2 == null) {
                    prop2 = new PropWrapper(name);
                    newProps.put(name, prop2);
                }
                prop2.getter = method;
                continue;
            }
            if (paramCount != 1 || !NameUtils.isSetter(methodName) || !StringUtils.isNotEmpty(name = NameUtils.propNameFromSetter(methodName))) continue;
            prop2 = (PropWrapper)newProps.get(name);
            if (prop2 == null) {
                prop2 = new PropWrapper(name);
                newProps.put(name, prop2);
            }
            prop2.setter = method;
        }
        for (Field field : fields = ReflectUtils.getFields(this.clazz)) {
            if (!field.isAccessible()) continue;
            String name = field.getName();
            PropWrapper prop3 = (PropWrapper)newProps.get(name);
            if (prop3 == null) {
                prop3 = new PropWrapper(name);
                newProps.put(name, prop3);
            }
            prop3.field = field;
        }
        newProps.values().stream().filter(prop -> prop.getter != null).forEach(prop -> this.props.put(prop.getName(), (PropWrapper)prop));
    }

    public Class<?> getJavaType() {
        return this.clazz;
    }

    public Map<String, PropWrapper> getProps() {
        return this.props;
    }

    public PropWrapper getProp(String name) {
        return this.props.get(name);
    }
}

