/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.retryer;

import com.dtflys.forest.exceptions.ForestRetryException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.retryer.ForestRetryer;

public class BackOffRetryer
extends ForestRetryer {
    protected final ForestRequest request;
    protected long waitedTime;

    public BackOffRetryer(ForestRequest request) {
        super(request);
        this.request = request;
        this.waitedTime = 0L;
    }

    @Override
    public void canRetry(ForestRetryException ex) throws Throwable {
        int currentCount = this.getCurrentRetryCount();
        int maxRetryCount = this.getMaxRetryCount();
        long maxRetryInterval = this.getMaxRetryInterval();
        if (currentCount >= maxRetryCount) {
            if (currentCount == 0) {
                throw ex.getCause() == null ? ex : ex.getCause();
            }
            throw ex;
        }
        long interval = this.nextInterval(currentCount);
        if (interval > maxRetryInterval) {
            interval = maxRetryInterval;
        }
        if (interval > 0L) {
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw ex;
            }
        }
        this.waitedTime += interval;
        this.getAndIncrementCurrentRetryCount();
    }

    protected long nextInterval(int currentCount) {
        long maxRetryInterval = this.getMaxRetryInterval();
        long interval = (long)Math.pow(2.0, currentCount) * 1000L;
        if (maxRetryInterval >= 0L && interval > maxRetryInterval) {
            return maxRetryInterval;
        }
        return interval;
    }

    public long getWaitedTime() {
        return this.waitedTime;
    }
}

