/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.ssl;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.http.ForestRequest;
import com.dtflys.forest.ssl.SSLKeyStore;
import com.dtflys.forest.ssl.TrustAllManager;
import com.dtflys.forest.utils.StringUtils;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;

public class SSLUtils {
    public static final String SSL_3 = "SSLv3";
    public static final String TLS_1 = "TLSv1";
    public static final String TLS_1_1 = "TLSv1.1";
    public static final String TLS_1_2 = "TLSv1.2";
    public static final String TLS_1_3 = "TLSv1.3";
    public static final String[] DEFAULT_PROTOCOLS_JDK8 = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2"};
    public static final String[] DEFAULT_PROTOCOLS_JDK11 = new String[]{"SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2", "TLSv1.3"};
    private static final X509TrustManager[] DEFAULT_TRUST_MANAGERS = new X509TrustManager[]{new TrustAllManager()};

    public static SSLContext customSSL(ForestRequest request) {
        SSLContext sslContext = null;
        SSLKeyStore fKeyStore = request.getKeyStore();
        KeyStore keyStore = fKeyStore.getTrustStore();
        String certPass = fKeyStore.getCertPass();
        if (keyStore != null) {
            try {
                char[] certPassCharArray = certPass.toCharArray();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("sunx509");
                kmf.init(keyStore, certPassCharArray);
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                SSLContextBuilder scBuilder = SSLContexts.custom();
                String protocol = request.getSslProtocol();
                if (StringUtils.isNotEmpty(protocol)) {
                    scBuilder.useProtocol(protocol);
                }
                scBuilder.loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy());
                if (certPass != null) {
                    scBuilder.loadKeyMaterial(keyStore, certPassCharArray);
                }
                sslContext = scBuilder.build();
            }
            catch (NoSuchAlgorithmException e) {
                throw new ForestRuntimeException(e);
            }
            catch (KeyManagementException e) {
                throw new ForestRuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new ForestRuntimeException(e);
            }
            catch (UnrecoverableKeyException e) {
                throw new ForestRuntimeException(e);
            }
        }
        return sslContext;
    }

    public static SSLContext createIgnoreVerifySSL(String sslProtocol) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sc = null;
        sc = StringUtils.isEmpty(sslProtocol) ? SSLContext.getInstance("TLS") : SSLContext.getInstance(sslProtocol);
        sc.init(null, DEFAULT_TRUST_MANAGERS, null);
        return sc;
    }

    public static SSLContext getSSLContext(ForestRequest request, String protocol) throws KeyManagementException, NoSuchAlgorithmException {
        if (request.getKeyStore() == null) {
            return SSLUtils.createIgnoreVerifySSL(protocol);
        }
        return SSLUtils.customSSL(request);
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory(ForestRequest request, String protocol) {
        if (request == null) {
            return null;
        }
        try {
            SSLContext sslContext = SSLUtils.getSSLContext(request, protocol);
            if (sslContext == null) {
                throw new ForestRuntimeException("SSL context cannot be initialized.");
            }
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException e) {
            throw new ForestRuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ForestRuntimeException(e);
        }
    }
}

