/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ForestCache<K, V> {
    private final Cache<K, V> cache;

    public ForestCache(long maxSize, Duration expireAfterAccess) {
        this.cache = Caffeine.newBuilder().maximumSize(maxSize).expireAfterAccess(expireAfterAccess).build();
    }

    public ForestCache(long maxSize, long expireAfterAccess, TimeUnit timeUnit) {
        this.cache = Caffeine.newBuilder().maximumSize(maxSize).expireAfterAccess(expireAfterAccess, timeUnit).build();
    }

    public ForestCache(long maxSize) {
        this.cache = Caffeine.newBuilder().maximumSize(maxSize).build();
    }

    public int size() {
        return (int)this.cache.estimatedSize();
    }

    public long evictionCount() {
        return this.cache.stats().evictionCount();
    }

    public boolean isEmpty() {
        return this.cache.estimatedSize() == 0L;
    }

    public boolean containsKey(K key) {
        return this.cache.asMap().containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.cache.asMap().containsValue(value);
    }

    public V get(K key) {
        return (V)this.cache.getIfPresent(key);
    }

    public void put(K key, V value) {
        this.cache.put(key, value);
    }

    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.cache.putAll(m);
    }

    public void clear() {
        this.cache.cleanUp();
    }

    public Map<K, V> toMap() {
        return this.cache.asMap();
    }

    public Set<K> keySet() {
        return this.cache.asMap().keySet();
    }

    public Collection<V> values() {
        return this.cache.asMap().values();
    }

    public Set<Map.Entry<K, V>> entrySet() {
        return this.cache.asMap().entrySet();
    }
}

