/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class GzipUtils {
    public static boolean isGzip(String contentEncoding) {
        String[] encodes;
        if (contentEncoding != null && (encodes = contentEncoding.split(",")).length > 0) {
            for (String encode : encodes) {
                if (!"gzip".equalsIgnoreCase(encode.trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static byte[] compressGzip(byte[] bytes) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream outputStream = new GZIPOutputStream(byteArrayOutputStream);){
            outputStream.write(bytes);
            outputStream.flush();
            outputStream.finish();
        }
        catch (Throwable th) {
            throw new ForestRuntimeException(th);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] compressGzip(String text, Charset charset) {
        return GzipUtils.compressGzip(text.getBytes(charset));
    }

    public static byte[] compressGzip(String text) {
        return GzipUtils.compressGzip(text.getBytes(StandardCharsets.UTF_8));
    }

    public static GZIPInputStream decompressGzipInputStream(InputStream in) throws IOException {
        GZIPInputStream gzipInputStream = new GZIPInputStream(in);
        return gzipInputStream;
    }

    public static byte[] decompressGzipToByteArray(GZIPInputStream gzipIn) throws IOException {
        return IOUtils.toByteArray((InputStream)gzipIn);
    }

    public static String decompressGzipToString(GZIPInputStream gzipIn, String encoding) throws IOException {
        return IOUtils.toString((InputStream)gzipIn, (String)encoding);
    }

    public static byte[] decompressGzipToByteArray(InputStream in) throws IOException {
        return IOUtils.toByteArray((InputStream)GzipUtils.decompressGzipInputStream(in));
    }

    public static String decompressGzipToString(InputStream in, String encoding) throws IOException {
        return IOUtils.toString((InputStream)GzipUtils.decompressGzipInputStream(in), (String)encoding);
    }

    public static String decompressGzipToString(byte[] bytes, String encoding) throws IOException {
        return IOUtils.toString((InputStream)GzipUtils.decompressGzipInputStream(new ByteArrayInputStream(bytes)), (String)encoding);
    }
}

