/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.dtflys.forest.utils.StringUtils;
import java.util.LinkedList;

public class NameUtils {
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    public static boolean isGetter(String name) {
        return name != null && name.length() > GETTER_PREFIX.length() && name.startsWith(GETTER_PREFIX);
    }

    public static boolean isSetter(String name) {
        return name != null && name.length() > SETTER_PREFIX.length() && name.startsWith(SETTER_PREFIX);
    }

    public static String[] splitCamelName(String name) {
        int len = name.length();
        LinkedList<String> names = new LinkedList<String>();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                String item = builder.toString();
                if (StringUtils.isNotBlank(item)) {
                    names.add(item);
                }
                builder = new StringBuilder();
                builder.append(Character.toLowerCase(ch));
                continue;
            }
            builder.append(ch);
        }
        String last = builder.toString();
        if (StringUtils.isNotBlank(last)) {
            names.add(last);
        }
        String[] result = new String[names.size()];
        return names.toArray(result);
    }

    public static String propNameFromGetter(String name) {
        return NameUtils.propNameFrom(name, GETTER_PREFIX);
    }

    public static String propNameFromSetter(String name) {
        return NameUtils.propNameFrom(name, SETTER_PREFIX);
    }

    private static String propNameFrom(String name, String prefix) {
        String[] strs = NameUtils.splitCamelName(name);
        String namePrefix = strs[0];
        if (!prefix.equals(namePrefix) || strs.length < 2) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < strs.length; ++i) {
            String str = strs[i];
            if (i > 1) {
                char[] chars = str.toCharArray();
                builder.append(String.valueOf(chars[0]).toUpperCase());
                if (chars.length <= 1) continue;
                for (int j = 1; j < chars.length; ++j) {
                    builder.append(chars[j]);
                }
                continue;
            }
            builder.append(str);
        }
        return builder.toString();
    }

    public static String setterName(String name) {
        String[] strs = NameUtils.splitCamelName(name);
        String prefix = strs[0];
        if (SETTER_PREFIX.equals(prefix)) {
            return name;
        }
        StringBuilder builder = new StringBuilder(SETTER_PREFIX);
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            builder.append(Character.toUpperCase(str.charAt(0))).append(str.substring(1));
        }
        return builder.toString();
    }
}

