/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class URLEncoder {
    private static final char SPACE = ' ';
    private static final char[] HEX_DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] USER_INFO_EXCLUDED_CHARACTERS = new char[]{'-', '.', '_', '+', '!', '(', ')', '*', ':', '=', '%'};
    private static final char[] PATH_EXCLUDED_CHARACTERS = new char[]{'-', '.', '_', '+', '!', '(', ')', '[', ']', '*', '/', ':', '?', '=', '$', '@', '&', '%', '~'};
    private static final char[] QUERY_VALUE_EXCLUDED_CHARACTERS = new char[]{'-', '.', '_', '+', '!', '(', ')', '[', ']', ',', '*', '/', ':', '?', '=', '%', '~'};
    private static final char[] QUERY_VALUE_EXCLUDED_CHARACTERS_WITH_BRACE = new char[]{'-', '.', '_', '+', '!', '{', '}', '(', ')', '[', ']', ',', '*', '/', ':', '?', '=', '%', '~'};
    private static final char[] X_WWW_FORM_URLENCODED_VALUE_EXCLUDED_CHARACTERS = new char[]{'-', '.', '_', '!', '{', '}', '[', ']', ',', '\"', '*', '/', ':', '?', '#', '=', '%'};
    private static final char[] ALL_EXCLUDED_CHARACTERS = new char[]{'*', '-', '.', '_'};
    public static final URLEncoder USER_INFO = URLEncoder.createUserInfoUrlEncoder();
    public static final URLEncoder PATH = URLEncoder.createPathUrlEncoder();
    public static final URLEncoder QUERY_VALUE = URLEncoder.createQueryValueUrlEncoder();
    public static final URLEncoder QUERY_VALUE_WITH_BRACE = URLEncoder.createQueryValueWithBraceUrlEncoder();
    public static final URLEncoder FORM_VALUE = URLEncoder.createXWwwFormUrlEncodedValueUrlEncoder();
    public static final URLEncoder ALL = URLEncoder.createAllUrlEncoder();
    private final BitSet excludedCharacters;
    private boolean encodeSpaceAsPlus = false;

    private static URLEncoder createURLEncoder(char[] excludedCharacters, boolean encodeSpaceAsPlus) {
        URLEncoder encoder = new URLEncoder();
        encoder.setEncodeSpaceAsPlus(encodeSpaceAsPlus);
        for (char ch : excludedCharacters) {
            encoder.excludeCharacter(ch);
        }
        return encoder;
    }

    public static URLEncoder createUserInfoUrlEncoder() {
        return URLEncoder.createURLEncoder(USER_INFO_EXCLUDED_CHARACTERS, false);
    }

    public static URLEncoder createPathUrlEncoder() {
        return URLEncoder.createURLEncoder(PATH_EXCLUDED_CHARACTERS, false);
    }

    public static URLEncoder createQueryValueUrlEncoder() {
        return URLEncoder.createURLEncoder(QUERY_VALUE_EXCLUDED_CHARACTERS, false);
    }

    public static URLEncoder createQueryValueWithBraceUrlEncoder() {
        return URLEncoder.createURLEncoder(QUERY_VALUE_EXCLUDED_CHARACTERS_WITH_BRACE, false);
    }

    public static URLEncoder createXWwwFormUrlEncodedValueUrlEncoder() {
        return URLEncoder.createURLEncoder(X_WWW_FORM_URLENCODED_VALUE_EXCLUDED_CHARACTERS, false);
    }

    public static URLEncoder createAllUrlEncoder() {
        return URLEncoder.createURLEncoder(ALL_EXCLUDED_CHARACTERS, false);
    }

    public URLEncoder() {
        this(new BitSet(256));
        char i;
        for (i = 'a'; i <= 'z'; i = (char)((char)(i + '\u0001'))) {
            this.excludeCharacter(i);
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.excludeCharacter(i);
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.excludeCharacter(i);
        }
    }

    private URLEncoder(BitSet excludedCharacters) {
        this.excludedCharacters = excludedCharacters;
    }

    public void excludeCharacter(char c) {
        this.excludedCharacters.set(c);
    }

    public void setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
    }

    public String encode(String path, String charset) {
        if (path == null) {
            return null;
        }
        try {
            Charset cs = StringUtils.isEmpty(charset) ? StandardCharsets.UTF_8 : Charset.forName(charset);
            return this.encode(path, cs);
        }
        catch (Throwable th) {
            throw new ForestRuntimeException(th);
        }
    }

    private boolean isURLEncoded(char[] charArray, int index) {
        if (charArray[index] != '%') {
            return false;
        }
        int len = charArray.length;
        if (index + 2 < len) {
            char ch1 = charArray[index + 1];
            char ch2 = charArray[index + 2];
            return Character.isDigit(ch1) && Character.isDigit(ch2);
        }
        return false;
    }

    public String encode(String path, Charset charset) {
        StringBuilder builder = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        char[] charArray = path.toCharArray();
        int len = charArray.length;
        for (int i = 0; i < len; ++i) {
            byte[] ba;
            char ch = charArray[i];
            if (this.isURLEncoded(charArray, i)) {
                builder.append(ch);
                continue;
            }
            if (this.excludedCharacters.get(ch)) {
                builder.append(ch);
                continue;
            }
            if (this.encodeSpaceAsPlus && ch == ' ') {
                builder.append('+');
                continue;
            }
            try {
                writer.write(ch);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                builder.append('%');
                int high = (toEncode & 0xF0) >>> 4;
                int low = toEncode & 0xF;
                builder.append(HEX_DIGITS_UPPER[high]);
                builder.append(HEX_DIGITS_UPPER[low]);
            }
            buf.reset();
        }
        return builder.toString();
    }
}

