/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.utils;

import com.dtflys.forest.exceptions.ForestRuntimeException;
import com.dtflys.forest.utils.StringUtils;
import com.dtflys.forest.utils.URLEncoder;
import java.io.UnsupportedEncodingException;

public final class URLUtils {
    private URLUtils() {
    }

    public static boolean isURL(String str) {
        return URLUtils.hasProtocol(str) || str.startsWith("file:/");
    }

    public static boolean hasProtocol(String url) {
        int len = url.length();
        char[] chars = url.toCharArray();
        for (int i = 0; i < len; ++i) {
            char ch = chars[i];
            if (ch != ':') continue;
            String protocol = url.substring(0, i);
            if (i + 1 >= len) {
                return false;
            }
            char nc = chars[i + 1];
            if (nc != '/') continue;
            return URLUtils.isValidProtocol(protocol);
        }
        return false;
    }

    private static boolean isValidProtocol(char[] charArray) {
        if (charArray.length < 1) {
            return false;
        }
        for (int i = 0; i < charArray.length; ++i) {
            char ch = charArray[i];
            if (Character.isAlphabetic(ch)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidProtocol(String protocol) {
        return URLUtils.isValidProtocol(protocol.toCharArray());
    }

    public static boolean isValidUrl(String url) {
        return URLUtils.hasProtocol(url);
    }

    public static void checkBaseURL(String baseUrl) {
        if (!URLUtils.hasProtocol(baseUrl)) {
            throw new ForestRuntimeException("base url has no protocol: " + baseUrl);
        }
    }

    public static String getValidBaseURL(String baseUrl) {
        int len;
        int lastIndex;
        char[] chars = baseUrl.toCharArray();
        if ('/' == chars[lastIndex = (len = chars.length) - 1]) {
            char ch;
            int i = lastIndex;
            while ((ch = chars[i]) == '/' && --i > 0) {
            }
            return baseUrl.substring(0, i + 1);
        }
        return baseUrl;
    }

    public static String getValidURL(String baseURL, String uri) {
        if (StringUtils.isNotEmpty(baseURL) && !URLUtils.hasProtocol(baseURL)) {
            baseURL = "http://" + baseURL;
        }
        if (!URLUtils.hasProtocol(uri)) {
            if (StringUtils.isNotEmpty(baseURL)) {
                if (StringUtils.isBlank(uri)) {
                    return baseURL;
                }
                if (baseURL.endsWith("/")) {
                    baseURL = URLUtils.getValidBaseURL(baseURL);
                }
                if (!uri.startsWith("/")) {
                    uri = "/" + uri;
                }
                return baseURL + uri;
            }
            return "http://" + uri;
        }
        return uri;
    }

    public static boolean isNonePort(Integer port) {
        return port == null || port < 0;
    }

    public static boolean isNotNonePort(Integer port) {
        return !URLUtils.isNonePort(port);
    }

    public static String allEncode(String content, String encode) {
        return URLEncoder.ALL.encode(content, encode);
    }

    public static String userInfoEncode(String content, String encode) {
        return URLEncoder.USER_INFO.encode(content, encode);
    }

    public static String pathEncode(String content, String encode) {
        return URLEncoder.PATH.encode(content, encode);
    }

    public static String refEncode(String content, String encode) {
        return URLEncoder.PATH.encode(content, encode);
    }

    public static String queryValueEncode(String content, String encode) {
        return URLEncoder.QUERY_VALUE.encode(content, encode);
    }

    public static String queryValueWithBraceEncode(String content, String encode) {
        return URLEncoder.QUERY_VALUE_WITH_BRACE.encode(content, encode);
    }

    public static String encode(String content, String charset) throws UnsupportedEncodingException {
        if (content == null) {
            return null;
        }
        if (URLUtils.isEncoded(content)) {
            return content;
        }
        if (URLUtils.hasProtocol(content)) {
            String query;
            String[] queries;
            String[] group = content.split("\\?");
            if (group.length > 1 && (queries = (query = group[1]).split("&")).length > 1) {
                return URLEncoder.PATH.encode(content, charset);
            }
            return content;
        }
        return URLEncoder.PATH.encode(content, charset);
    }

    public static boolean isEncoded(String content) {
        char[] chars = content.toCharArray();
        int len = chars.length;
        for (int i = 0; i < len - 1; ++i) {
            char nc;
            char ch = chars[i];
            if (ch != '%' || !Character.isDigit(nc = chars[i + 1]) && nc != 'A' && nc != 'B' && nc != 'C' && nc != 'D' && nc != 'E' && nc != 'F') continue;
            return true;
        }
        return false;
    }
}

