/*
 * Decompiled with CFR 0.152.
 */
package com.dtflys.forest.scanner;

import com.dtflys.forest.file.SpringResource;
import com.dtflys.forest.http.body.RequestBodyBuilder;
import com.dtflys.forest.http.body.SpringMultipartRequestBodyBuilder;
import com.dtflys.forest.http.body.SpringResourceRequestBodyBuilder;
import com.dtflys.forest.multipart.ForestMultipartFactory;
import com.dtflys.forest.utils.ClientFactoryBeanUtils;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

public class ClassPathClientScanner
extends ClassPathBeanDefinitionScanner {
    private static final String[] FOREST_METHOD_ANNOTATION_NAMES = new String[]{"com.dtflys.forest.annotation.Backend", "com.dtflys.forest.annotation.Headers", "com.dtflys.forest.annotation.Address", "com.dtflys.forest.annotation.Request", "com.dtflys.forest.annotation.Get", "com.dtflys.forest.annotation.GetRequest", "com.dtflys.forest.annotation.Post", "com.dtflys.forest.annotation.PostRequest", "com.dtflys.forest.annotation.Put", "com.dtflys.forest.annotation.PutRequest", "com.dtflys.forest.annotation.HeadRequest", "com.dtflys.forest.annotation.Options", "com.dtflys.forest.annotation.OptionsRequest", "com.dtflys.forest.annotation.Patch", "com.dtflys.forest.annotation.PatchRequest", "com.dtflys.forest.annotation.Trace", "com.dtflys.forest.annotation.TraceRequest"};
    private final String configurationId;
    private boolean allInterfaces = true;

    public ClassPathClientScanner(String configurationId, BeanDefinitionRegistry registry) {
        super(registry, false);
        this.configurationId = configurationId;
        this.registerFilters();
        this.registerMultipartTypes();
    }

    public void registerMultipartTypes() {
        ForestMultipartFactory.registerFactory(Resource.class, SpringResource.class);
        RequestBodyBuilder.registerBodyBuilder(Resource.class, (RequestBodyBuilder)new SpringResourceRequestBodyBuilder());
        try {
            Class<?> multipartFileClass = Class.forName("org.springframework.web.multipart.MultipartFile");
            Class<?> springMultipartFileClass = Class.forName("com.dtflys.forest.file.SpringMultipartFile");
            ForestMultipartFactory.registerFactory(multipartFileClass, springMultipartFileClass);
            RequestBodyBuilder.registerBodyBuilder(multipartFileClass, (RequestBodyBuilder)new SpringMultipartRequestBodyBuilder());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private boolean interfaceFilter(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) {
        ClassMetadata classMetadata = metadataReader.getClassMetadata();
        if (!classMetadata.isInterface() || classMetadata.isFinal()) {
            return false;
        }
        String[] superClassNames = metadataReader.getClassMetadata().getInterfaceNames();
        boolean hasSuperForestClient = false;
        for (String superClassName : superClassNames) {
            try {
                MetadataReader superMetaReader = metadataReaderFactory.getMetadataReader(superClassName);
                hasSuperForestClient = this.interfaceFilter(superMetaReader, metadataReaderFactory);
            }
            catch (IOException superMetaReader) {
                // empty catch block
            }
            if (!hasSuperForestClient) continue;
            return true;
        }
        AnnotationMetadata annotationMetadata = metadataReader.getAnnotationMetadata();
        for (String annotationTypeName : annotationMetadata.getAnnotationTypes()) {
            if ("com.dtflys.forest.annotation.ForestClient".equals(annotationTypeName)) {
                return true;
            }
            if (!"com.dtflys.forest.annotation.BaseRequest".equals(annotationTypeName)) continue;
            return true;
        }
        for (String methodAnnName : FOREST_METHOD_ANNOTATION_NAMES) {
            if (!annotationMetadata.hasAnnotatedMethods(methodAnnName)) continue;
            return true;
        }
        return false;
    }

    public void registerFilters() {
        if (this.allInterfaces) {
            this.addIncludeFilter((metadataReader, metadataReaderFactory) -> this.interfaceFilter(metadataReader, metadataReaderFactory));
        }
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> {
            String className = metadataReader.getClassMetadata().getClassName();
            return className.endsWith("package-info");
        });
    }

    private void processBeanDefinitions(Set<BeanDefinitionHolder> beanDefinitions) {
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            String beanClassName = definition.getBeanClassName();
            ClientFactoryBeanUtils.setupClientFactoryBean((AbstractBeanDefinition)definition, this.configurationId, beanClassName);
            this.logger.info((Object)("[Forest] Created Forest Client Bean with name '" + holder.getBeanName() + "' and Proxy of '" + beanClassName + "' client interface"));
        }
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (!beanDefinitions.isEmpty()) {
            this.processBeanDefinitions(beanDefinitions);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }
}

