/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.file.util;

import com.dynatrace.file.util.DynatraceConfiguration;
import com.dynatrace.file.util.FilePoller;
import com.dynatrace.file.util.FilePollerFactory;
import com.dynatrace.file.util.PollBasedFilePoller;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Properties;
import java.util.logging.Logger;

public class DynatraceFileBasedConfigurationProvider {
    private boolean alreadyInitialized = false;
    private static final Logger logger = Logger.getLogger(DynatraceFileBasedConfigurationProvider.class.getName());
    private static final String PROPERTIES_FILENAME = "/var/lib/dynatrace/enrichment/endpoint/endpoint.properties";
    private FilePoller filePoller;
    private DynatraceConfiguration config;

    private DynatraceFileBasedConfigurationProvider(String fileName) {
        this.setUp(fileName, null);
    }

    public static DynatraceFileBasedConfigurationProvider getInstance() {
        return ProviderHolder.INSTANCE;
    }

    private void setUp(String fileName, Duration pollInterval) {
        this.alreadyInitialized = false;
        this.config = new DynatraceConfiguration();
        PollBasedFilePoller poller = null;
        try {
            if (!Files.exists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
                logger.info("File based configuration does not exist, serving default config.");
            } else {
                poller = FilePollerFactory.getPollBased(fileName, pollInterval != null ? pollInterval : Duration.ofSeconds(60L));
            }
        }
        catch (InvalidPathException e) {
            logger.info(() -> String.format("%s is not a valid file path (%s).", fileName, e.getMessage()));
        }
        catch (IllegalArgumentException e) {
            logger.warning(() -> String.format("File polling could not be initialized: %s", e.getMessage()));
        }
        this.filePoller = poller;
        this.updateConfigFromFile(fileName);
    }

    public void forceOverwriteConfig(String fileName, Duration pollInterval) {
        this.closePoller();
        if (fileName != null) {
            logger.warning("Overwriting config. This should ONLY happen in testing.");
            this.setUp(fileName, pollInterval);
        }
    }

    private void closePoller() {
        if (this.filePoller != null) {
            logger.warning("Shutting down file polling mechanism. This should ONLY happen in testing.");
            try {
                this.filePoller.close();
            }
            catch (IOException e) {
                logger.warning("Failed to shut down polling mechanism: " + e);
            }
            this.filePoller = null;
        }
    }

    private void updateConfigFromFile(String fileName) {
        if (this.filePoller == null) {
            logger.finest("No file watch set up, serving default values.");
            return;
        }
        try (FileInputStream inputStream = new FileInputStream(fileName);){
            String newToken;
            Properties props = new Properties();
            props.load(inputStream);
            String newEndpoint = this.tryGetMetricsEndpoint(props);
            if (newEndpoint != null) {
                this.config.setMetricIngestEndpoint(newEndpoint);
            }
            if ((newToken = this.tryGetToken(props)) != null) {
                this.config.setMetricIngestToken(newToken);
            }
            this.alreadyInitialized = true;
        }
        catch (IOException e) {
            logger.info("Failed reading properties from file.");
        }
    }

    private String tryGetToken(Properties props) {
        String newToken = props.getProperty("DT_METRICS_INGEST_API_TOKEN");
        if (newToken == null) {
            logger.warning("Could not read property with key 'DT_METRICS_INGEST_API_TOKEN'.");
            return null;
        }
        if (!newToken.equals(this.config.getMetricIngestToken())) {
            if (this.alreadyInitialized) {
                logger.info("API Token refreshed.");
            }
            return newToken;
        }
        return null;
    }

    private String tryGetMetricsEndpoint(Properties props) {
        String newEndpoint = props.getProperty("DT_METRICS_INGEST_URL");
        if (newEndpoint == null) {
            logger.fine("Could not read property with key 'DT_METRICS_INGEST_URL'.");
            return null;
        }
        if (!newEndpoint.equals(this.config.getMetricIngestEndpoint())) {
            if (this.alreadyInitialized) {
                logger.info(() -> String.format("Read new endpoint: %s", newEndpoint));
            }
            return newEndpoint;
        }
        return null;
    }

    private void updateConfigIfChanged() {
        if (this.filePoller != null && this.filePoller.fileContentsUpdated()) {
            this.updateConfigFromFile(this.filePoller.getWatchedFilePath());
        }
    }

    public String getMetricIngestEndpoint() {
        this.updateConfigIfChanged();
        return this.config.getMetricIngestEndpoint();
    }

    public String getMetricIngestToken() {
        this.updateConfigIfChanged();
        return this.config.getMetricIngestToken();
    }

    private static class ProviderHolder {
        private static final DynatraceFileBasedConfigurationProvider INSTANCE = new DynatraceFileBasedConfigurationProvider("/var/lib/dynatrace/enrichment/endpoint/endpoint.properties");

        private ProviderHolder() {
        }
    }
}

