/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.CodePoints;

final class StringValueValidator {
    private StringValueValidator() {
    }

    static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    static boolean shouldEscapeString(int codePoint) {
        return codePoint == CodePoints.COMMA || codePoint == CodePoints.EQUALS || codePoint == CodePoints.BLANK || codePoint == CodePoints.BACKSLASH || codePoint == CodePoints.QUOTE;
    }

    static boolean shouldEscapeQuotedString(int codePoint) {
        return codePoint == CodePoints.QUOTE || codePoint == CodePoints.BACKSLASH;
    }

    static boolean isEmptyQuoted(String value) {
        return "\"\"".equals(value);
    }

    static boolean isInvalidCodePoint(int codePoint) {
        switch (Character.getType(codePoint)) {
            case 0: {
                if (codePoint >= 129280 && codePoint <= 129535) {
                    return false;
                }
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    static boolean canAppendToValue(int currentValueLength, int codePoint, boolean isQuoted, boolean includeEscapeChar, int maxDimensionValueLength) {
        int sizeToAdd = currentValueLength + Character.charCount(codePoint);
        if (isQuoted) {
            sizeToAdd += Character.charCount(CodePoints.QUOTE);
        }
        if (includeEscapeChar) {
            sizeToAdd += Character.charCount(CodePoints.BACKSLASH);
        }
        return sizeToAdd <= maxDimensionValueLength;
    }

    static boolean normalizationRequiredUnqoutedStringValue(String value, int maxDimensionValueLength) {
        int codePoint;
        int length = value.length();
        if (length > maxDimensionValueLength) {
            return true;
        }
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            if (!StringValueValidator.isInvalidCodePoint(codePoint) && !StringValueValidator.shouldEscapeString(codePoint)) continue;
            return true;
        }
        return false;
    }

    static boolean normalizationRequiredQuotedStringValue(String value, int maxDimensionValueLength) {
        int codePoint;
        int length = value.length();
        if (length > maxDimensionValueLength) {
            return true;
        }
        int quoteSize = Character.charCount(CodePoints.QUOTE);
        int contentLength = length - quoteSize;
        for (int offset = quoteSize; offset < contentLength; offset += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            if (!StringValueValidator.isInvalidCodePoint(codePoint) && !StringValueValidator.shouldEscapeQuotedString(codePoint)) continue;
            return true;
        }
        return false;
    }

    static enum State {
        START,
        QUOTED_STRING_INTERMEDIATE,
        QUOTED_STRING;

    }
}

