/*
 * Decompiled with CFR 0.152.
 */
package com.dyuproject.protostuff;

import com.dyuproject.protostuff.ByteArrayInput;
import com.dyuproject.protostuff.CodedInput;
import com.dyuproject.protostuff.IOUtil;
import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.LimitedInputStream;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.Output;
import com.dyuproject.protostuff.Pipe;
import com.dyuproject.protostuff.ProtobufException;
import com.dyuproject.protostuff.ProtobufOutput;
import com.dyuproject.protostuff.Schema;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtobufIOUtil {
    private ProtobufIOUtil() {
    }

    public static Pipe newPipe(byte[] data) {
        return ProtobufIOUtil.newPipe(data, 0, data.length);
    }

    public static Pipe newPipe(byte[] data, int offset, int len) {
        final ByteArrayInput byteArrayInput = new ByteArrayInput(data, offset, len, false);
        return new Pipe(){

            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                return byteArrayInput;
            }

            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    return;
                }
                assert (input == byteArrayInput);
            }
        };
    }

    public static Pipe newPipe(InputStream in) {
        final CodedInput codedInput = new CodedInput(in, false);
        return new Pipe(){

            protected Input begin(Pipe.Schema<?> pipeSchema) throws IOException {
                return codedInput;
            }

            protected void end(Pipe.Schema<?> pipeSchema, Input input, boolean cleanupOnly) throws IOException {
                if (cleanupOnly) {
                    return;
                }
                assert (input == codedInput);
            }
        };
    }

    public static <T> void mergeFrom(byte[] data, T message, Schema<T> schema) {
        IOUtil.mergeFrom(data, 0, data.length, message, schema, false);
    }

    public static <T> void mergeFrom(byte[] data, int offset, int length, T message, Schema<T> schema) {
        IOUtil.mergeFrom(data, offset, length, message, schema, false);
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        IOUtil.mergeFrom(in, message, schema, false);
    }

    public static <T> void mergeFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        IOUtil.mergeFrom(in, buffer.buffer, message, schema, false);
    }

    public static <T> void mergeDelimitedFrom(InputStream in, T message, Schema<T> schema) throws IOException {
        IOUtil.mergeDelimitedFrom(in, message, schema, false);
    }

    public static <T> void mergeDelimitedFrom(InputStream in, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        IOUtil.mergeDelimitedFrom(in, buffer.buffer, message, schema, false);
    }

    public static <T> void mergeDelimitedFrom(DataInput in, T message, Schema<T> schema) throws IOException {
        IOUtil.mergeDelimitedFrom(in, message, schema, false);
    }

    public static <T> byte[] toByteArray(T message, Schema<T> schema, LinkedBuffer buffer) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        try {
            schema.writeTo((Output)output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a byte array threw an IOException (should never happen).", e);
        }
        return output.toByteArray();
    }

    public static <T> int writeTo(LinkedBuffer buffer, T message, Schema<T> schema) {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        try {
            schema.writeTo((Output)output, message);
        }
        catch (IOException e) {
            throw new RuntimeException("Serializing to a LinkedBuffer threw an IOException (should never happen).", e);
        }
        return output.getSize();
    }

    public static <T> int writeTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        schema.writeTo((Output)output, message);
        return LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
    }

    public static <T> int writeDelimitedTo(OutputStream out, T message, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        schema.writeTo((Output)output, message);
        int size = output.getSize();
        ProtobufOutput.writeRawVarInt32Bytes(out, size);
        int msgSize = LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
        assert (size == msgSize);
        return size;
    }

    public static <T> int writeDelimitedTo(DataOutput out, T message, Schema<T> schema) throws IOException {
        LinkedBuffer buffer = new LinkedBuffer(256);
        ProtobufOutput output = new ProtobufOutput(buffer);
        schema.writeTo((Output)output, message);
        int size = output.getSize();
        ProtobufOutput.writeRawVarInt32Bytes(out, size);
        int msgSize = LinkedBuffer.writeTo((DataOutput)out, (LinkedBuffer)buffer);
        assert (size == msgSize);
        return size;
    }

    public static <T> int writeListTo(OutputStream out, List<T> messages, Schema<T> schema, LinkedBuffer buffer) throws IOException {
        if (buffer.start != buffer.offset) {
            throw new IllegalArgumentException("Buffer previously used and had not been reset.");
        }
        ProtobufOutput output = new ProtobufOutput(buffer);
        int totalSize = 0;
        for (T m : messages) {
            schema.writeTo((Output)output, m);
            int size = output.getSize();
            ProtobufOutput.writeRawVarInt32Bytes(out, size);
            int msgSize = LinkedBuffer.writeTo((OutputStream)out, (LinkedBuffer)buffer);
            assert (size == msgSize);
            totalSize += size;
            output.clear();
        }
        return totalSize;
    }

    public static <T> List<T> parseListFrom(InputStream in, Schema<T> schema) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        byte[] buf = null;
        int biggestLen = 0;
        LimitedInputStream lin = null;
        int size = in.read();
        while (size != -1) {
            int len;
            Object message = schema.newMessage();
            list.add(message);
            int n = len = size < 128 ? size : CodedInput.readRawVarint32(in, size);
            if (len != 0) {
                Object input;
                if (len > 4096) {
                    if (lin == null) {
                        lin = new LimitedInputStream(in);
                    }
                    input = new CodedInput(lin.limit(len), false);
                    schema.mergeFrom((Input)input, message);
                    ((CodedInput)input).checkLastTagWas(0);
                } else {
                    if (biggestLen < len) {
                        buf = new byte[len];
                        biggestLen = len;
                    }
                    IOUtil.fillBufferFrom(in, buf, 0, len);
                    input = new ByteArrayInput(buf, 0, len, false);
                    try {
                        schema.mergeFrom((Input)input, message);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw ProtobufException.truncatedMessage(e);
                    }
                    ((ByteArrayInput)input).checkLastTagWas(0);
                }
            }
            size = in.read();
        }
        return list;
    }
}

