/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class LibraryLoader {
    static final String SEPARATOR;
    static final String DELIMITER;
    static final String SWT_LIB_DIR = ".j2v8";

    LibraryLoader() {
    }

    private static String computeLibraryShortName() {
        String base = "j2v8";
        String osSuffix = LibraryLoader.getOS();
        String archSuffix = LibraryLoader.getArchSuffix();
        return base + "_" + osSuffix + "_" + archSuffix;
    }

    private static String computeLibraryFullName() {
        return "lib" + LibraryLoader.computeLibraryShortName() + "." + LibraryLoader.getOSFileExtension();
    }

    static void loadLibrary(String tempDirectory) {
        if (LibraryLoader.isAndroid()) {
            System.loadLibrary("j2v8");
            return;
        }
        StringBuffer message = new StringBuffer();
        String libShortName = LibraryLoader.computeLibraryShortName();
        String libFullName = LibraryLoader.computeLibraryFullName();
        String ideLocation = System.getProperty("user.dir") + SEPARATOR + "jni" + SEPARATOR + LibraryLoader.computeLibraryFullName();
        String path = null;
        if (LibraryLoader.load(libFullName, message)) {
            return;
        }
        if (LibraryLoader.load(libShortName, message)) {
            return;
        }
        if (new File(ideLocation).exists() && LibraryLoader.load(ideLocation, message)) {
            return;
        }
        path = tempDirectory != null ? tempDirectory : System.getProperty("user.home");
        if (LibraryLoader.extract(path + SEPARATOR + libFullName, libFullName, message)) {
            return;
        }
        throw new UnsatisfiedLinkError("Could not load J2V8 library. Reasons: " + message.toString());
    }

    static boolean load(String libName, StringBuffer message) {
        try {
            if (libName.indexOf(SEPARATOR) != -1) {
                System.load(libName);
            } else {
                System.loadLibrary(libName);
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            if (message.length() == 0) {
                message.append(DELIMITER);
            }
            message.append('\t');
            message.append(e.getMessage());
            message.append(DELIMITER);
            return false;
        }
    }

    static boolean extract(String fileName, String mappedName, StringBuffer message) {
        block12: {
            FileOutputStream os = null;
            InputStream is = null;
            File file = new File(fileName);
            boolean extracted = false;
            try {
                if (file.exists()) {
                    file.delete();
                }
                if ((is = LibraryLoader.class.getResourceAsStream("/" + mappedName)) != null) {
                    int read;
                    extracted = true;
                    byte[] buffer = new byte[4096];
                    os = new FileOutputStream(fileName);
                    while ((read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, read);
                    }
                    os.close();
                    is.close();
                    LibraryLoader.chmod("755", fileName);
                    if (LibraryLoader.load(fileName, message)) {
                        return true;
                    }
                }
            }
            catch (Throwable e) {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!extracted || !file.exists()) break block12;
                file.delete();
            }
        }
        return false;
    }

    static void chmod(String permision, String path) {
        if (LibraryLoader.isWindows()) {
            return;
        }
        try {
            Runtime.getRuntime().exec(new String[]{"chmod", permision, path}).waitFor();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static String getOsName() {
        return System.getProperty("os.name") + System.getProperty("java.specification.vendor");
    }

    static boolean isWindows() {
        return LibraryLoader.getOsName().startsWith("Windows");
    }

    static boolean isMac() {
        return LibraryLoader.getOsName().startsWith("Mac");
    }

    static boolean isLinux() {
        return LibraryLoader.getOsName().startsWith("Linux");
    }

    static boolean isNativeClient() {
        return LibraryLoader.getOsName().startsWith("nacl");
    }

    static boolean isAndroid() {
        return LibraryLoader.getOsName().contains("Android");
    }

    static String getArchSuffix() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("i686")) {
            return "x86";
        }
        if (arch.equals("amd64")) {
            return "x86_64";
        }
        if (arch.equals("nacl")) {
            return "armv7l";
        }
        if (arch.equals("aarch64")) {
            return "armv7l";
        }
        return arch;
    }

    static String getOSFileExtension() {
        if (LibraryLoader.isWindows()) {
            return "dll";
        }
        if (LibraryLoader.isMac()) {
            return "dylib";
        }
        if (LibraryLoader.isLinux()) {
            return "so";
        }
        if (LibraryLoader.isNativeClient()) {
            return "so";
        }
        throw new UnsatisfiedLinkError("Unsupported platform: " + LibraryLoader.getOsName());
    }

    static String getOS() {
        if (LibraryLoader.isWindows()) {
            return "win32";
        }
        if (LibraryLoader.isMac()) {
            return "macosx";
        }
        if (LibraryLoader.isLinux() && !LibraryLoader.isAndroid()) {
            return "linux";
        }
        if (LibraryLoader.isAndroid()) {
            return "android";
        }
        throw new UnsatisfiedLinkError("Unsupported platform: " + LibraryLoader.getOsName());
    }

    static {
        DELIMITER = System.getProperty("line.separator");
        SEPARATOR = System.getProperty("file.separator");
    }
}

