/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8ArrayBuffer;
import com.eclipsesource.v8.V8Value;
import java.nio.ByteBuffer;

public class V8TypedArray
extends V8Array {
    public V8TypedArray(V8 v8, V8ArrayBuffer buffer, int type, int offset, int size) {
        super(v8, new V8ArrayData(buffer, offset, size, type));
    }

    private V8TypedArray(V8 v8) {
        super(v8);
    }

    public V8ArrayBuffer getBuffer() {
        return (V8ArrayBuffer)this.get("buffer");
    }

    public ByteBuffer getByteBuffer() {
        V8ArrayBuffer buffer = this.getBuffer();
        try {
            ByteBuffer byteBuffer = buffer.getBackingStore();
            return byteBuffer;
        }
        finally {
            buffer.release();
        }
    }

    @Override
    protected void initialize(long runtimePtr, Object data) {
        this.v8.checkThread();
        if (data == null) {
            super.initialize(runtimePtr, data);
            return;
        }
        V8ArrayData arrayData = (V8ArrayData)data;
        this.checkArrayProperties(arrayData);
        long handle = this.createTypedArray(runtimePtr, arrayData);
        this.released = false;
        this.addObjectReference(handle);
    }

    private long createTypedArray(long runtimePtr, V8ArrayData arrayData) {
        switch (arrayData.type) {
            case 16: {
                return this.v8.initNewV8Float32Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 2: {
                return this.v8.initNewV8Float64Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 15: {
                return this.v8.initNewV8UInt32Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 13: {
                return this.v8.initNewV8Int16Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 14: {
                return this.v8.initNewV8UInt16Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 1: {
                return this.v8.initNewV8Int32Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 11: {
                return this.v8.initNewV8UInt8Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 9: {
                return this.v8.initNewV8Int8Array(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
            case 12: {
                return this.v8.initNewV8UInt8ClampedArray(runtimePtr, ((V8ArrayData)arrayData).buffer.objectHandle, arrayData.offset, arrayData.size);
            }
        }
        throw new IllegalArgumentException("Cannot create a typed array of type " + V8Value.getStringRepresentation(arrayData.type));
    }

    public static int getStructureSize(int type) {
        switch (type) {
            case 2: {
                return 8;
            }
            case 1: 
            case 15: 
            case 16: {
                return 4;
            }
            case 13: 
            case 14: {
                return 2;
            }
            case 9: 
            case 11: 
            case 12: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Cannot create a typed array of type " + V8Value.getStringRepresentation(type));
    }

    private void checkArrayProperties(V8ArrayData arrayData) {
        this.checkOffset(arrayData);
        this.checkSize(arrayData);
    }

    private void checkSize(V8ArrayData arrayData) {
        if (arrayData.size < 0) {
            throw new IllegalStateException("RangeError: Invalid typed array length");
        }
        int limit = arrayData.size * V8TypedArray.getStructureSize(arrayData.type) + arrayData.offset;
        if (limit > arrayData.buffer.getBackingStore().limit()) {
            throw new IllegalStateException("RangeError: Invalid typed array length");
        }
    }

    private void checkOffset(V8ArrayData arrayData) {
        if (arrayData.offset % V8TypedArray.getStructureSize(arrayData.type) != 0) {
            throw new IllegalStateException("RangeError: Start offset of Int32Array must be a multiple of " + V8TypedArray.getStructureSize(arrayData.type));
        }
    }

    @Override
    protected V8Value createTwin() {
        return new V8TypedArray(this.v8);
    }

    private static class V8ArrayData {
        private V8ArrayBuffer buffer;
        private int offset;
        private int size;
        private int type;

        public V8ArrayData(V8ArrayBuffer buffer, int offset, int size, int type) {
            this.buffer = buffer;
            this.offset = offset;
            this.size = size;
            this.type = type;
        }
    }
}

