/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.utils.V8Runnable;

public final class ConcurrentV8 {
    private V8 v8 = V8.createV8Runtime();

    public ConcurrentV8() {
        this.v8.getLocker().release();
    }

    public V8 getV8() {
        return this.v8;
    }

    public synchronized void run(V8Runnable runnable) {
        try {
            this.v8.getLocker().acquire();
            runnable.run(this.v8);
        }
        finally {
            if (this.v8 != null && this.v8.getLocker() != null && this.v8.getLocker().hasLock()) {
                this.v8.getLocker().release();
            }
        }
    }

    public void release() {
        if (this.v8 != null && !this.v8.isReleased()) {
            this.run(new V8Runnable(){

                @Override
                public void run(V8 v8) {
                    if (v8 != null && !v8.isReleased()) {
                        v8.release();
                    }
                }
            });
        }
    }
}

