/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8ArrayBuffer;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8TypedArray;
import com.eclipsesource.v8.V8Value;
import com.eclipsesource.v8.utils.TypeAdapter;
import com.eclipsesource.v8.utils.V8Map;
import com.eclipsesource.v8.utils.V8PropertyMap;
import com.eclipsesource.v8.utils.typedarrays.ArrayBuffer;
import com.eclipsesource.v8.utils.typedarrays.Float32Array;
import com.eclipsesource.v8.utils.typedarrays.Float64Array;
import com.eclipsesource.v8.utils.typedarrays.Int16Array;
import com.eclipsesource.v8.utils.typedarrays.Int32Array;
import com.eclipsesource.v8.utils.typedarrays.Int8Array;
import com.eclipsesource.v8.utils.typedarrays.TypedArray;
import com.eclipsesource.v8.utils.typedarrays.UInt16Array;
import com.eclipsesource.v8.utils.typedarrays.UInt32Array;
import com.eclipsesource.v8.utils.typedarrays.UInt8Array;
import com.eclipsesource.v8.utils.typedarrays.UInt8ClampedArray;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class V8ObjectUtils {
    private static final Object IGNORE = new Object();
    private static final TypeAdapter DEFAULT_TYPE_ADAPTER = new DefaultTypeAdapter();

    public static Object getValue(Object v8Object) {
        return V8ObjectUtils.getValue(v8Object, DEFAULT_TYPE_ADAPTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(Object v8Object, TypeAdapter adapter) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            if (v8Object instanceof V8Value) {
                int type = ((V8Value)v8Object).getV8Type();
                Object object = V8ObjectUtils.getValue(v8Object, type, cache, adapter);
                return object;
            }
            Object object = v8Object;
            return object;
        }
        finally {
            cache.release();
        }
    }

    public static Map<String, ? super Object> toMap(V8Object object) {
        return V8ObjectUtils.toMap(object, DEFAULT_TYPE_ADAPTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ? super Object> toMap(V8Object object, TypeAdapter adapter) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            Map<String, ? super Object> map = V8ObjectUtils.toMap(object, cache, adapter);
            return map;
        }
        finally {
            cache.release();
        }
    }

    public static List<? super Object> toList(V8Array array) {
        return V8ObjectUtils.toList(array, DEFAULT_TYPE_ADAPTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<? super Object> toList(V8Array array, TypeAdapter adapter) {
        V8Map<Object> cache = new V8Map<Object>();
        try {
            List<? super Object> list = V8ObjectUtils.toList(array, cache, adapter);
            return list;
        }
        finally {
            cache.release();
        }
    }

    public static Object getTypedArray(V8Array array, int arrayType, Object result) {
        int length = array.length();
        if (arrayType == 1) {
            int[] intArray = (int[])result;
            if (intArray == null || intArray.length < length) {
                intArray = new int[length];
            }
            array.getIntegers(0, length, intArray);
            return intArray;
        }
        if (arrayType == 2) {
            double[] doubleArray = (double[])result;
            if (doubleArray == null || doubleArray.length < length) {
                doubleArray = new double[length];
            }
            array.getDoubles(0, length, doubleArray);
            return doubleArray;
        }
        if (arrayType == 3) {
            boolean[] booleanArray = (boolean[])result;
            if (booleanArray == null || booleanArray.length < length) {
                booleanArray = new boolean[length];
            }
            array.getBooleans(0, length, booleanArray);
            return booleanArray;
        }
        if (arrayType == 4) {
            String[] stringArray = (String[])result;
            if (stringArray == null || stringArray.length < length) {
                stringArray = new String[length];
            }
            array.getStrings(0, length, stringArray);
            return stringArray;
        }
        if (arrayType == 9) {
            byte[] byteArray = (byte[])result;
            if (byteArray == null || byteArray.length < length) {
                byteArray = new byte[length];
            }
            array.getBytes(0, length, byteArray);
            return byteArray;
        }
        throw new RuntimeException("Unsupported bulk load type: " + arrayType);
    }

    public static Object getTypedArray(V8Array array, int arrayType) {
        int length = array.length();
        if (arrayType == 1) {
            return array.getIntegers(0, length);
        }
        if (arrayType == 2) {
            return array.getDoubles(0, length);
        }
        if (arrayType == 3) {
            return array.getBooleans(0, length);
        }
        if (arrayType == 4) {
            return array.getStrings(0, length);
        }
        throw new RuntimeException("Unsupported bulk load type: " + arrayType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8Object toV8Object(V8 v8, Map<String, ? extends Object> map) {
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            V8Object v8Object = V8ObjectUtils.toV8Object(v8, map, cache).twin();
            return v8Object;
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8Array toV8Array(V8 v8, List<? extends Object> list) {
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            V8Array v8Array = V8ObjectUtils.toV8Array(v8, list, cache).twin();
            return v8Array;
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getV8Result(V8 v8, Object value) {
        if (value == null) {
            return null;
        }
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            Object result = V8ObjectUtils.getV8Result(v8, value, cache);
            if (result instanceof V8Object) {
                V8Object v8Object = ((V8Object)result).twin();
                return v8Object;
            }
            Object object = result;
            return object;
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushValue(V8 v8, V8Array array, Object value) {
        Hashtable<Object, V8Value> cache = new Hashtable<Object, V8Value>();
        try {
            V8ObjectUtils.pushValue(v8, array, value, cache);
        }
        finally {
            for (V8Value v8Object : cache.values()) {
                v8Object.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(V8Array array, int index) {
        V8Map<Object> cache = new V8Map<Object>();
        Object object = null;
        int type = 99;
        try {
            object = array.get(index);
            type = array.getType(index);
            Object object2 = V8ObjectUtils.getValue(object, type, cache, DEFAULT_TYPE_ADAPTER);
            return object2;
        }
        finally {
            if (object instanceof Releasable) {
                ((Releasable)object).release();
            }
            cache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(V8Array array, int index, TypeAdapter adapter) {
        V8Map<Object> cache = new V8Map<Object>();
        Object object = null;
        int type = 99;
        try {
            object = array.get(index);
            type = array.getType(index);
            Object object2 = V8ObjectUtils.getValue(object, type, cache, adapter);
            return object2;
        }
        finally {
            if (object instanceof Releasable) {
                ((Releasable)object).release();
            }
            cache.release();
        }
    }

    public static Object getValue(V8Object object, String key) {
        return V8ObjectUtils.getValue(object, key, DEFAULT_TYPE_ADAPTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getValue(V8Object v8Object, String key, TypeAdapter adapter) {
        V8Map<Object> cache = new V8Map<Object>();
        Object object = null;
        int type = 99;
        try {
            object = v8Object.get(key);
            type = v8Object.getType(key);
            Object object2 = V8ObjectUtils.getValue(object, type, cache, adapter);
            return object2;
        }
        finally {
            if (object instanceof Releasable) {
                ((Releasable)object).release();
            }
            cache.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, ? super Object> toMap(V8Object v8Object, V8Map<Object> cache, TypeAdapter adapter) {
        String[] keys;
        if (v8Object == null) {
            return Collections.emptyMap();
        }
        if (cache.containsKey(v8Object)) {
            return (Map)cache.get(v8Object);
        }
        V8PropertyMap<Object> result = new V8PropertyMap<Object>();
        cache.put(v8Object, (Object)result);
        for (String key : keys = v8Object.getKeys()) {
            Object object = null;
            int type = 99;
            try {
                object = v8Object.get(key);
                type = v8Object.getType(key);
                Object value = V8ObjectUtils.getValue(object, type, cache, adapter);
                if (value == IGNORE) continue;
                result.put(key, value);
            }
            finally {
                if (object instanceof Releasable) {
                    ((Releasable)object).release();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<? super Object> toList(V8Array array, V8Map<Object> cache, TypeAdapter adapter) {
        if (array == null) {
            return Collections.emptyList();
        }
        if (cache.containsKey(array)) {
            return (List)cache.get(array);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        cache.put(array, (Object)result);
        for (int i = 0; i < array.length(); ++i) {
            Object object = null;
            int type = 99;
            try {
                object = array.get(i);
                type = array.getType(i);
                Object value = V8ObjectUtils.getValue(object, type, cache, adapter);
                if (value == IGNORE) continue;
                result.add(value);
                continue;
            }
            finally {
                if (object instanceof Releasable) {
                    ((Releasable)object).release();
                }
            }
        }
        return result;
    }

    private static V8Object toV8Object(V8 v8, Map<String, ? extends Object> map, Map<Object, V8Value> cache) {
        if (cache.containsKey(map)) {
            return (V8Object)cache.get(map);
        }
        V8Object result = new V8Object(v8);
        cache.put(map, result);
        try {
            for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
                V8ObjectUtils.setValue(v8, result, entry.getKey(), entry.getValue(), cache);
            }
        }
        catch (IllegalStateException e) {
            result.release();
            throw e;
        }
        return result;
    }

    private static V8Array toV8Array(V8 v8, List<? extends Object> list, Map<Object, V8Value> cache) {
        if (cache.containsKey(new ListWrapper(list))) {
            return (V8Array)cache.get(new ListWrapper(list));
        }
        V8Array result = new V8Array(v8);
        cache.put(new ListWrapper(list), result);
        try {
            for (int i = 0; i < list.size(); ++i) {
                Object value = list.get(i);
                V8ObjectUtils.pushValue(v8, result, value, cache);
            }
        }
        catch (IllegalStateException e) {
            result.release();
            throw e;
        }
        return result;
    }

    private static V8ArrayBuffer toV8ArrayBuffer(V8 v8, ArrayBuffer arrayBuffer, Map<Object, V8Value> cache) {
        if (cache.containsKey(arrayBuffer)) {
            return (V8ArrayBuffer)cache.get(arrayBuffer);
        }
        V8ArrayBuffer result = new V8ArrayBuffer(v8, arrayBuffer.getByteBuffer());
        cache.put(arrayBuffer, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static V8TypedArray toV8TypedArray(V8 v8, TypedArray typedArray, Map<Object, V8Value> cache) {
        if (cache.containsKey(typedArray)) {
            return (V8TypedArray)cache.get(typedArray);
        }
        V8ArrayBuffer arrayBuffer = new V8ArrayBuffer(v8, typedArray.getByteBuffer());
        try {
            V8TypedArray result = new V8TypedArray(v8, arrayBuffer, typedArray.getType(), 0, typedArray.length());
            cache.put(typedArray, result);
            V8TypedArray v8TypedArray = result;
            return v8TypedArray;
        }
        finally {
            arrayBuffer.release();
        }
    }

    private static Object getV8Result(V8 v8, Object value, Map<Object, V8Value> cache) {
        if (cache.containsKey(value)) {
            return cache.get(value);
        }
        if (value instanceof Map) {
            return V8ObjectUtils.toV8Object(v8, (Map)value, cache);
        }
        if (value instanceof List) {
            return V8ObjectUtils.toV8Array(v8, (List)value, cache);
        }
        if (value instanceof TypedArray) {
            return V8ObjectUtils.toV8TypedArray(v8, (TypedArray)value, cache);
        }
        if (value instanceof ArrayBuffer) {
            return V8ObjectUtils.toV8ArrayBuffer(v8, (ArrayBuffer)value, cache);
        }
        return value;
    }

    private static void pushValue(V8 v8, V8Array result, Object value, Map<Object, V8Value> cache) {
        if (value == null) {
            result.pushUndefined();
        } else if (value instanceof Integer) {
            result.push(value);
        } else if (value instanceof Long) {
            result.push(new Double(((Long)value).longValue()));
        } else if (value instanceof Double) {
            result.push(value);
        } else if (value instanceof Float) {
            result.push(value);
        } else if (value instanceof String) {
            result.push((String)value);
        } else if (value instanceof Boolean) {
            result.push(value);
        } else if (value instanceof V8Object) {
            result.push((V8Object)value);
        } else if (value instanceof TypedArray) {
            V8TypedArray v8TypedArray = V8ObjectUtils.toV8TypedArray(v8, (TypedArray)value, cache);
            result.push(v8TypedArray);
        } else if (value instanceof ArrayBuffer) {
            V8ArrayBuffer v8ArrayBuffer = V8ObjectUtils.toV8ArrayBuffer(v8, (ArrayBuffer)value, cache);
            result.push(v8ArrayBuffer);
        } else if (value instanceof Map) {
            V8Object object = V8ObjectUtils.toV8Object(v8, (Map)value, cache);
            result.push(object);
        } else if (value instanceof List) {
            V8Array array = V8ObjectUtils.toV8Array(v8, (List)value, cache);
            result.push(array);
        } else {
            throw new IllegalStateException("Unsupported Object of type: " + value.getClass());
        }
    }

    private static void setValue(V8 v8, V8Object result, String key, Object value, Map<Object, V8Value> cache) {
        if (value == null) {
            result.addUndefined(key);
        } else if (value instanceof Integer) {
            result.add(key, (Integer)value);
        } else if (value instanceof Long) {
            result.add(key, ((Long)value).longValue());
        } else if (value instanceof Double) {
            result.add(key, (Double)value);
        } else if (value instanceof Float) {
            result.add(key, ((Float)value).floatValue());
        } else if (value instanceof String) {
            result.add(key, (String)value);
        } else if (value instanceof Boolean) {
            result.add(key, (Boolean)value);
        } else if (value instanceof V8Object) {
            result.add(key, (V8Object)value);
        } else if (value instanceof TypedArray) {
            V8TypedArray typedArray = V8ObjectUtils.toV8TypedArray(v8, (TypedArray)value, cache);
            result.add(key, typedArray);
        } else if (value instanceof ArrayBuffer) {
            V8ArrayBuffer v8ArrayBuffer = V8ObjectUtils.toV8ArrayBuffer(v8, (ArrayBuffer)value, cache);
            result.add(key, v8ArrayBuffer);
        } else if (value instanceof Map) {
            V8Object object = V8ObjectUtils.toV8Object(v8, (Map)value, cache);
            result.add(key, object);
        } else if (value instanceof List) {
            V8Array array = V8ObjectUtils.toV8Array(v8, (List)value, cache);
            result.add(key, array);
        } else {
            throw new IllegalStateException("Unsupported Object of type: " + value.getClass());
        }
    }

    private static Object getValue(Object value, int valueType, V8Map<Object> cache, TypeAdapter adapter) {
        Object adapterResult = adapter.adapt(valueType, value);
        if (TypeAdapter.DEFAULT != adapterResult) {
            return adapterResult;
        }
        switch (valueType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return value;
            }
            case 7: {
                return IGNORE;
            }
            case 10: {
                return new ArrayBuffer(((V8ArrayBuffer)value).getBackingStore());
            }
            case 8: {
                return V8ObjectUtils.toTypedArray((V8Array)value);
            }
            case 5: {
                return V8ObjectUtils.toList((V8Array)value, cache, adapter);
            }
            case 6: {
                return V8ObjectUtils.toMap((V8Object)value, cache, adapter);
            }
            case 0: {
                return null;
            }
            case 99: {
                return V8.getUndefined();
            }
        }
        throw new IllegalStateException("Cannot convert type " + V8Value.getStringRepresentation(valueType));
    }

    private static Object toTypedArray(V8Array typedArray) {
        int arrayType = typedArray.getType();
        ByteBuffer buffer = ((V8TypedArray)typedArray).getByteBuffer();
        switch (arrayType) {
            case 9: {
                return new Int8Array(buffer);
            }
            case 11: {
                return new UInt8Array(buffer);
            }
            case 12: {
                return new UInt8ClampedArray(buffer);
            }
            case 13: {
                return new Int16Array(buffer);
            }
            case 14: {
                return new UInt16Array(buffer);
            }
            case 1: {
                return new Int32Array(buffer);
            }
            case 15: {
                return new UInt32Array(buffer);
            }
            case 16: {
                return new Float32Array(buffer);
            }
            case 2: {
                return new Float64Array(buffer);
            }
        }
        throw new IllegalStateException("Known Typed Array type: " + V8Value.getStringRepresentation(arrayType));
    }

    private V8ObjectUtils() {
    }

    static class ListWrapper {
        private List<? extends Object> list;

        public ListWrapper(List<? extends Object> list) {
            this.list = list;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ListWrapper) {
                return ((ListWrapper)obj).list == this.list;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.list);
        }
    }

    static class DefaultTypeAdapter
    implements TypeAdapter {
        DefaultTypeAdapter() {
        }

        @Override
        public Object adapt(int type, Object value) {
            return TypeAdapter.DEFAULT;
        }
    }
}

