/*
   Copyright 2011 Janne Jalkanen

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package com.ecyrd.speed4j;

/**
 *  Thrown whenever there's a problem with Speed4J configuration.
 */
public class ConfigurationException extends RuntimeException
{
    private static final long serialVersionUID = 1L;

    public ConfigurationException(String message, Throwable rootCause)
    {
        super( message, rootCause );
    }
    
    public ConfigurationException(Throwable rootCause)
    {
        super( rootCause );
    }

    public ConfigurationException( String message )
    {
        super( message );
    }
}