/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.event.EventStream;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import com.typesafe.akka.extension.quartz.QuartzCalendars$;
import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedulerExtension$;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.akka.extension.quartz.SimpleActorMessageJob;
import com.typesafe.akka.extension.quartz.package$;
import com.typesafe.config.Config;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.core.jmx.JobDataMapSupport;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\rEq!B\u0001\u0003\u0011\u0003i\u0011\u0001G)vCJ$(pU2iK\u0012,H.\u001a:FqR,gn]5p]*\u00111\u0001B\u0001\u0007cV\f'\u000f\u001e>\u000b\u0005\u00151\u0011!C3yi\u0016t7/[8o\u0015\t9\u0001\"\u0001\u0003bW.\f'BA\u0005\u000b\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u00031E+\u0018M\u001d;{'\u000eDW\rZ;mKJ,\u0005\u0010^3og&|gn\u0005\u0002\u0010%A\u00191cF\r\u000e\u0003QQ!!\u0006\f\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u001dI!\u0001\u0007\u000b\u0003\u0019\u0015CH/\u001a8tS>t7*Z=\u0011\u00059Qb\u0001\u0002\t\u0003\u0001m\u00192A\u0007\u000f#!\ti\u0002%D\u0001\u001f\u0015\u0005y\u0012!B:dC2\f\u0017BA\u0011\u001f\u0005\u0019\te.\u001f*fMB\u00111cI\u0005\u0003IQ\u0011\u0011\"\u0012=uK:\u001c\u0018n\u001c8\t\u0011\u0019R\"\u0011!Q\u0001\n\u001d\naa]=ti\u0016l\u0007CA\n)\u0013\tICCA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W\u000eC\u0003,5\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u000335BQA\n\u0016A\u0002\u001dBqa\f\u000eC\u0002\u0013%\u0001'A\u0002m_\u001e,\u0012!\r\t\u0003eUj\u0011a\r\u0006\u0003iY\tQ!\u001a<f]RL!AN\u001a\u0003\u001d1{wmZ5oO\u0006#\u0017\r\u001d;fe\"1\u0001H\u0007Q\u0001\nE\nA\u0001\\8hA!)!H\u0007C\u0001w\u0005i1o\u00195fIVdWM\u001d(b[\u0016,\u0012\u0001\u0010\t\u0003{\u0001s!!\b \n\u0005}r\u0012A\u0002)sK\u0012,g-\u0003\u0002B\u0005\n11\u000b\u001e:j]\u001eT!a\u0010\u0010\t\u000f\u0011S\"\u0019!C\t\u000b\u000611m\u001c8gS\u001e,\u0012A\u0012\t\u0003\u000f&k\u0011\u0001\u0013\u0006\u0003\t\"I!A\u0013%\u0003\r\r{gNZ5h\u0011\u0019a%\u0004)A\u0005\r\u000691m\u001c8gS\u001e\u0004\u0003b\u0002(\u001b\u0005\u0004%\taT\u0001\fi\"\u0014X-\u00193D_VtG/F\u0001Q!\ti\u0012+\u0003\u0002S=\t\u0019\u0011J\u001c;\t\rQS\u0002\u0015!\u0003Q\u00031!\bN]3bI\u000e{WO\u001c;!\u0011\u001d1&D1A\u0005\u0002=\u000ba\u0002\u001e5sK\u0006$\u0007K]5pe&$\u0018\u0010\u0003\u0004Y5\u0001\u0006I\u0001U\u0001\u0010i\"\u0014X-\u00193Qe&|'/\u001b;zA!9!L\u0007b\u0001\n\u0003Y\u0016\u0001\u00063bK6|g\u000e\u00165sK\u0006$7o\u0018\u0013r[\u0006\u00148.F\u0001]!\tiR,\u0003\u0002_=\t9!i\\8mK\u0006t\u0007B\u00021\u001bA\u0003%A,A\u000beC\u0016lwN\u001c+ie\u0016\fGm]0%c6\f'o\u001b\u0011\t\u000f\tT\"\u0019!C\u0001G\u0006yA-\u001a4bk2$H+[7fu>tW-F\u0001e!\t)'.D\u0001g\u0015\t9\u0007.\u0001\u0003vi&d'\"A5\u0002\t)\fg/Y\u0005\u0003W\u001a\u0014\u0001\u0002V5nKj{g.\u001a\u0005\u0007[j\u0001\u000b\u0011\u00023\u0002!\u0011,g-Y;miRKW.\u001a>p]\u0016\u0004\u0003bB8\u001b\u0001\u0004%\t\u0001]\u0001\ng\u000eDW\rZ;mKN,\u0012!\u001d\t\u0005e^d\u00140D\u0001t\u0015\t!X/A\u0005j[6,H/\u00192mK*\u0011aOH\u0001\u000bG>dG.Z2uS>t\u0017B\u0001=t\u0005\ri\u0015\r\u001d\t\u0003\u001diL!a\u001f\u0002\u0003\u001dE+\u0018M\u001d;{'\u000eDW\rZ;mK\"9QP\u0007a\u0001\n\u0003q\u0018!D:dQ\u0016$W\u000f\\3t?\u0012*\u0017\u000fF\u0002\u0000\u0003\u000b\u00012!HA\u0001\u0013\r\t\u0019A\b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\bq\f\t\u00111\u0001r\u0003\rAH%\r\u0005\b\u0003\u0017Q\u0002\u0015)\u0003r\u0003)\u00198\r[3ek2,7\u000f\t\u0005\n\u0003\u001fQ\"\u0019!C\u0001\u0003#\t1B];o]&twMS8cgV\u0011\u00111\u0003\t\b\u0003+\tY\u0002PA\u000f\u001b\t\t9BC\u0002\u0002\u001aU\fq!\\;uC\ndW-C\u0002y\u0003/\u0001B!a\b\u0002(5\u0011\u0011\u0011\u0005\u0006\u0004\u0007\u0005\r\"BAA\u0013\u0003\ry'oZ\u0005\u0005\u0003S\t\tC\u0001\u0004K_\n\\U-\u001f\u0005\t\u0003[Q\u0002\u0015!\u0003\u0002\u0014\u0005a!/\u001e8oS:<'j\u001c2tA!9\u0011\u0011\u0007\u000e\u0005\u0002\u0005M\u0012aB:uC:$'-\u001f\u000b\u0002\u007f\"1\u0011q\u0007\u000e\u0005\u0002m\u000bq\"[:J]N#\u0018M\u001c3cs6{G-\u001a\u0005\b\u0003wQB\u0011AA\u001f\u0003\u0015\u0019H/\u0019:u)\u0005a\u0006BBA!5\u0011\u00051,A\u0005jgN#\u0018M\u001d;fI\"9\u0011Q\t\u000e\u0005\u0002\u0005\u001d\u0013a\u00038fqR$&/[4hKJ$B!!\u0013\u0002VA)Q$a\u0013\u0002P%\u0019\u0011Q\n\u0010\u0003\r=\u0003H/[8o!\r)\u0017\u0011K\u0005\u0004\u0003'2'\u0001\u0002#bi\u0016Dq!a\u0016\u0002D\u0001\u0007A(\u0001\u0003oC6,\u0007bBA.5\u0011\u0005\u00111G\u0001\u000bgV\u001c\b/\u001a8e\u00032d\u0007bBA05\u0011\u0005\u0011\u0011M\u0001\tg\",H\u000fZ8x]R\u0019q0a\u0019\t\u0013\u0005\u0015\u0014Q\fI\u0001\u0002\u0004a\u0016!F<bSR4uN\u001d&pEN$vnQ8na2,G/\u001a\u0005\b\u0003SRB\u0011AA6\u0003)\u0019Xo\u001d9f]\u0012TuN\u0019\u000b\u00049\u00065\u0004bBA,\u0003O\u0002\r\u0001\u0010\u0005\b\u0003cRB\u0011AA:\u0003%\u0011Xm];nK*{'\rF\u0002]\u0003kBq!a\u0016\u0002p\u0001\u0007A\bC\u0004\u0002zi!\t!a\r\u0002\u0013I,7/^7f\u00032d\u0007bBA?5\u0011\u0005\u0011qP\u0001\nG\u0006t7-\u001a7K_\n$2\u0001XAA\u0011\u001d\t9&a\u001fA\u0002qBq!!\"\u001b\t\u0003\t9)A\tde\u0016\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$\u0002#a\u0014\u0002\n\u0006-\u0015QSAM\u0003?\u000b\u0019+a*\t\u000f\u0005]\u00131\u0011a\u0001y!A\u0011QRAB\u0001\u0004\ty)\u0001\u0005sK\u000e,\u0017N^3s!\r\u0019\u0012\u0011S\u0005\u0004\u0003'#\"\u0001C!di>\u0014(+\u001a4\t\u000f\u0005]\u00151\u0011a\u00019\u0005\u0019Qn]4\t\u0015\u0005m\u00151\u0011I\u0001\u0002\u0004\ti*A\u0006eKN\u001c'/\u001b9uS>t\u0007\u0003B\u000f\u0002LqBq!!)\u0002\u0004\u0002\u0007A(\u0001\bde>tW\t\u001f9sKN\u001c\u0018n\u001c8\t\u0015\u0005\u0015\u00161\u0011I\u0001\u0002\u0004\ti*\u0001\u0005dC2,g\u000eZ1s\u0011%\tI+a!\u0011\u0002\u0003\u0007A-\u0001\u0005uS6,'p\u001c8f\u0011\u001d\tiK\u0007C\u0001\u0003_\u000b\u0011#\u001e9eCR,'j\u001c2TG\",G-\u001e7f)A\ty%!-\u00024\u0006U\u0016qWA]\u0003w\u000bi\fC\u0004\u0002X\u0005-\u0006\u0019\u0001\u001f\t\u0011\u00055\u00151\u0016a\u0001\u0003\u001fCq!a&\u0002,\u0002\u0007A\u0004\u0003\u0006\u0002\u001c\u0006-\u0006\u0013!a\u0001\u0003;Cq!!)\u0002,\u0002\u0007A\b\u0003\u0006\u0002&\u0006-\u0006\u0013!a\u0001\u0003;C\u0011\"!+\u0002,B\u0005\t\u0019\u00013\t\u000f\u0005\u0005'\u0004\"\u0001\u0002D\u0006\tB-\u001a7fi\u0016TuNY*dQ\u0016$W\u000f\\3\u0015\u0007q\u000b)\rC\u0004\u0002X\u0005}\u0006\u0019\u0001\u001f\t\u000f\u0005%'\u0004\"\u0001\u0002L\u0006iQO\\:dQ\u0016$W\u000f\\3K_\n$2\u0001XAg\u0011\u001d\t9&a2A\u0002qBq!!5\u001b\t\u0003\t\u0019.\u0001\bde\u0016\fG/Z*dQ\u0016$W\u000f\\3\u0015\u0017}\f).a6\u0002Z\u0006m\u0017Q\u001c\u0005\b\u0003/\ny\r1\u0001=\u0011)\tY*a4\u0011\u0002\u0003\u0007\u0011Q\u0014\u0005\b\u0003C\u000by\r1\u0001=\u0011)\t)+a4\u0011\u0002\u0003\u0007\u0011Q\u0014\u0005\n\u0003S\u000by\r%AA\u0002\u0011Dq!!9\u001b\t\u0003\t\u0019/A\u0007sKN\u001c\u0007.\u001a3vY\u0016TuN\u0019\u000b\u0011\u0003\u001f\n)/a:\u0002j\u0006-\u0018Q^Ax\u0003cDq!a\u0016\u0002`\u0002\u0007A\b\u0003\u0005\u0002\u000e\u0006}\u0007\u0019AAH\u0011\u001d\t9*a8A\u0002qA!\"a'\u0002`B\u0005\t\u0019AAO\u0011\u001d\t\t+a8A\u0002qB!\"!*\u0002`B\u0005\t\u0019AAO\u0011%\tI+a8\u0011\u0002\u0003\u0007A\rC\u0004\u0002vj!I!a>\u0002\u001dI,Wn\u001c<f'\u000eDW\rZ;mKR\u0019q0!?\t\u000f\u0005]\u00131\u001fa\u0001y!9\u0011Q \u000e\u0005\u0002\u0005}\u0018\u0001C:dQ\u0016$W\u000f\\3\u0015\u0011\u0005=#\u0011\u0001B\u0002\u0005\u000bAq!a\u0016\u0002|\u0002\u0007A\b\u0003\u0005\u0002\u000e\u0006m\b\u0019AAH\u0011\u001d\t9*a?A\u0002qAq!!@\u001b\t\u0003\u0011I\u0001\u0006\u0005\u0002P\t-!Q\u0002B\u000b\u0011\u001d\t9Fa\u0002A\u0002qB\u0001\"!$\u0003\b\u0001\u0007!q\u0002\t\u0004'\tE\u0011b\u0001B\n)\tq\u0011i\u0019;peN+G.Z2uS>t\u0007bBAL\u0005\u000f\u0001\r\u0001\b\u0005\b\u0003{TB\u0011\u0001B\r)!\tyEa\u0007\u0003\u001e\t\u0015\u0002bBA,\u0005/\u0001\r\u0001\u0010\u0005\t\u0003\u001b\u00139\u00021\u0001\u0003 A\u0019!G!\t\n\u0007\t\r2GA\u0006Fm\u0016tGo\u0015;sK\u0006l\u0007bBAL\u0005/\u0001\r\u0001\b\u0005\b\u0003{TB\u0011\u0001B\u0015))\tyEa\u000b\u0003.\t=\"\u0011\u0007\u0005\b\u0003/\u00129\u00031\u0001=\u0011!\tiIa\nA\u0002\u0005=\u0005bBAL\u0005O\u0001\r\u0001\b\u0005\t\u0005g\u00119\u00031\u0001\u0002J\u0005I1\u000f^1si\u0012\u000bG/\u001a\u0005\b\u0003{TB\u0011\u0001B\u001c))\tyE!\u000f\u0003<\tu\"q\b\u0005\b\u0003/\u0012)\u00041\u0001=\u0011!\tiI!\u000eA\u0002\t=\u0001bBAL\u0005k\u0001\r\u0001\b\u0005\t\u0005g\u0011)\u00041\u0001\u0002J!9\u0011Q \u000e\u0005\u0002\t\rCCCA(\u0005\u000b\u00129E!\u0013\u0003L!9\u0011q\u000bB!\u0001\u0004a\u0004\u0002CAG\u0005\u0003\u0002\rAa\b\t\u000f\u0005]%\u0011\ta\u00019!A!1\u0007B!\u0001\u0004\tI\u0005C\u0004\u0003Pi!IA!\u0015\u0002!M\u001c\u0007.\u001a3vY\u0016Le\u000e^3s]\u0006dGCCA(\u0005'\u0012)Fa\u0016\u0003Z!9\u0011q\u000bB'\u0001\u0004a\u0004bBAG\u0005\u001b\u0002\r\u0001\b\u0005\b\u0003/\u0013i\u00051\u0001\u001d\u0011!\u0011\u0019D!\u0014A\u0002\u0005%\u0003b\u0002B/5\u0011E!qL\u0001\fg\u000eDW\rZ;mK*{'\r\u0006\u0006\u0003b\t\u0015$q\rB5\u0005W\"B!a\u0014\u0003d!9\u0011Q B.\u0001\u0004I\bbBA,\u00057\u0002\r\u0001\u0010\u0005\b\u0003\u001b\u0013Y\u00061\u0001\u001d\u0011\u001d\t9Ja\u0017A\u0002qA\u0001Ba\r\u0003\\\u0001\u0007\u0011\u0011\n\u0005\b\u0005_RB\u0011CA\u001a\u0003MIg.\u001b;jC2L7/Z\"bY\u0016tG-\u0019:t\u0011)\u0011\u0019H\u0007EC\u0002\u0013E!QO\u0001\u000bi\"\u0014X-\u00193Q_>dWC\u0001B<!\u0011\u0011IHa \u000e\u0005\tm$\u0002\u0002B?\u0003C\tQa]5na2LAA!!\u0003|\t\u00012+[7qY\u0016$\u0006N]3bIB{w\u000e\u001c\u0005\u000b\u0005\u000bS\u0002\u0012!Q!\n\t]\u0014a\u0003;ie\u0016\fG\rU8pY\u0002B!B!#\u001b\u0011\u000b\u0007I\u0011\u0003BF\u0003!QwNY*u_J,WC\u0001BG!\u0011\u0011yI!&\u000e\u0005\tE%\u0002\u0002BJ\u0003C\t1a\u001d9j\u0013\u0011\u00119J!%\u0003\u0011){'m\u0015;pe\u0016D!Ba'\u001b\u0011\u0003\u0005\u000b\u0015\u0002BG\u0003%QwNY*u_J,\u0007\u0005\u0003\u0006\u0003 jA)\u0019!C\t\u0005C\u000b\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\t\r\u0006\u0003BA\u0010\u0005KKAAa*\u0002\"\tI1k\u00195fIVdWM\u001d\u0005\u000b\u0005WS\u0002\u0012!Q!\n\t\r\u0016AC:dQ\u0016$W\u000f\\3sA!I!q\u0016\u000e\u0012\u0002\u0013\u0005!\u0011W\u0001\u0013g\",H\u000fZ8x]\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00034*\u001aAL!.,\u0005\t]\u0006\u0003\u0002B]\u0005\u0007l!Aa/\u000b\t\tu&qX\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!1\u001f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u000b\u0014YLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011B!3\u001b#\u0003%\tAa3\u00027\r\u0014X-\u0019;f\u0015>\u00147k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iM\u000b\u0003\u0002\u001e\nU\u0006\"\u0003Bi5E\u0005I\u0011\u0001Bf\u0003m\u0019'/Z1uK*{'mU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%m!I!Q\u001b\u000e\u0012\u0002\u0013\u0005!q[\u0001\u001cGJ,\u0017\r^3K_\n\u001c6\r[3ek2,G\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\te'f\u00013\u00036\"I!Q\u001c\u000e\u0012\u0002\u0013\u0005!1Z\u0001\u0019GJ,\u0017\r^3TG\",G-\u001e7fI\u0011,g-Y;mi\u0012\u0012\u0004\"\u0003Bq5E\u0005I\u0011\u0001Bf\u0003a\u0019'/Z1uKN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0005KT\u0012\u0013!C\u0001\u0005/\f\u0001d\u0019:fCR,7k\u00195fIVdW\r\n3fM\u0006,H\u000e\u001e\u00136\u0011%\u0011IOGI\u0001\n\u0003\u0011Y-A\u000eva\u0012\fG/\u001a&pEN\u001b\u0007.\u001a3vY\u0016$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0005[T\u0012\u0013!C\u0001\u0005\u0017\f1$\u001e9eCR,'j\u001c2TG\",G-\u001e7fI\u0011,g-Y;mi\u00122\u0004\"\u0003By5E\u0005I\u0011\u0001Bl\u0003m)\b\u000fZ1uK*{'mU2iK\u0012,H.\u001a\u0013eK\u001a\fW\u000f\u001c;%o!I!Q\u001f\u000e\u0012\u0002\u0013\u0005!1Z\u0001\u0018e\u0016\u001c8\r[3ek2,'j\u001c2%I\u00164\u0017-\u001e7uIQB\u0011B!?\u001b#\u0003%\tAa3\u0002/I,7o\u00195fIVdWMS8cI\u0011,g-Y;mi\u00122\u0004\"\u0003B\u007f5E\u0005I\u0011\u0001Bl\u0003]\u0011Xm]2iK\u0012,H.\u001a&pE\u0012\"WMZ1vYR$s\u0007\u0003\u0004,\u001f\u0011\u00051\u0011\u0001\u000b\u0002\u001b!91QA\b\u0005B\r\u001d\u0011aA4fiR\u0019\u0011d!\u0003\t\u000f\u0019\u001a\u0019\u00011\u0001\u0004\fA\u00191c!\u0004\n\u0007\r=ACA\u0006BGR|'oU=ti\u0016l\u0007")
public class QuartzSchedulerExtension
implements Extension {
    private final ExtendedActorSystem system;
    private final LoggingAdapter com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log;
    private final Config config;
    private final int threadCount;
    private final int threadPriority;
    private final boolean daemonThreads_$qmark;
    private final TimeZone defaultTimezone;
    private scala.collection.immutable.Map<String, QuartzSchedule> schedules;
    private final scala.collection.mutable.Map<String, JobKey> runningJobs;
    private SimpleThreadPool threadPool;
    private JobStore jobStore;
    private Scheduler scheduler;
    private volatile byte bitmap$0;

    public static QuartzSchedulerExtension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension get(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return QuartzSchedulerExtension$.MODULE$.apply(actorSystem);
    }

    public static Extension createExtension(ExtendedActorSystem extendedActorSystem) {
        return QuartzSchedulerExtension$.MODULE$.createExtension(extendedActorSystem);
    }

    public static ExtensionId<QuartzSchedulerExtension> lookup() {
        return QuartzSchedulerExtension$.MODULE$.lookup();
    }

    /*
     * WARNING - void declaration
     */
    private SimpleThreadPool threadPool$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                SimpleThreadPool _tp = new SimpleThreadPool(this.threadCount(), this.threadPriority());
                _tp.setThreadNamePrefix("AKKA_QRTZ_");
                _tp.setMakeThreadsDaemons(this.daemonThreads_$qmark());
                this.threadPool = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.threadPool;
        }
    }

    private JobStore jobStore$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.jobStore = new RAMJobStore();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.jobStore;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Scheduler scheduler$lzycompute() {
        QuartzSchedulerExtension quartzSchedulerExtension = this;
        synchronized (quartzSchedulerExtension) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                void var2_2;
                DirectSchedulerFactory.getInstance().createScheduler(this.schedulerName(), this.system.name(), (ThreadPool)this.threadPool(), this.jobStore());
                Scheduler scheduler2 = DirectSchedulerFactory.getInstance().getScheduler(this.schedulerName());
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Initialized a Quartz Scheduler '{}'", (Object)scheduler2);
                this.system.registerOnTermination((Function0)new Serializable(this, scheduler2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ QuartzSchedulerExtension $outer;
                    private final Scheduler scheduler$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Shutting down Quartz Scheduler with ActorSystem Termination (Any jobs awaiting completion will end as well, as actors are ending)...");
                        this.scheduler$1.shutdown(false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.scheduler$1 = scheduler$1;
                    }
                });
                this.scheduler = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.scheduler;
        }
    }

    public LoggingAdapter com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log() {
        return this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log;
    }

    public String schedulerName() {
        return new StringOps(Predef$.MODULE$.augmentString("QuartzScheduler~%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.system.name()}));
    }

    public Config config() {
        return this.config;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public int threadPriority() {
        return this.threadPriority;
    }

    public boolean daemonThreads_$qmark() {
        return this.daemonThreads_$qmark;
    }

    public TimeZone defaultTimezone() {
        return this.defaultTimezone;
    }

    public scala.collection.immutable.Map<String, QuartzSchedule> schedules() {
        return this.schedules;
    }

    public void schedules_$eq(scala.collection.immutable.Map<String, QuartzSchedule> x$1) {
        this.schedules = x$1;
    }

    public scala.collection.mutable.Map<String, JobKey> runningJobs() {
        return this.runningJobs;
    }

    public void standby() {
        this.scheduler().standby();
    }

    public boolean isInStandbyMode() {
        return this.scheduler().isInStandbyMode();
    }

    public boolean start() {
        boolean bl;
        block4: {
            boolean bl2;
            block3: {
                block2: {
                    bl = this.isStarted();
                    if (!bl) break block2;
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("Cannot start scheduler, already started.");
                    bl2 = false;
                    break block3;
                }
                if (bl) break block4;
                this.scheduler().start();
                bl2 = true;
            }
            return bl2;
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    public boolean isStarted() {
        return this.scheduler().isStarted();
    }

    public Option<Date> nextTrigger(String name) {
        return this.runningJobs().get((Object)name).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuartzSchedulerExtension $outer;

            public final Option<Date> apply(JobKey jobKey) {
                return ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.$outer.scheduler().getTriggersOfJob(jobKey)).asScala()).headOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Date apply(Trigger trigger) {
                        return trigger.getNextFireTime();
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void suspendAll() {
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Suspending all Quartz jobs.");
        this.scheduler().pauseAll();
    }

    public void shutdown(boolean waitForJobsToComplete) {
        this.scheduler().shutdown(waitForJobsToComplete);
    }

    public boolean shutdown$default$1() {
        return false;
    }

    public boolean suspendJob(String name) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.runningJobs().get((Object)name);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JobKey job = (JobKey)some.x();
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Suspending Quartz Job '{}'", (Object)name);
                    this.scheduler().pauseJob(job);
                    bl = true;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("No running Job named '{}' found: Cannot suspend", (Object)name);
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public boolean resumeJob(String name) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.runningJobs().get((Object)name);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JobKey job = (JobKey)some.x();
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Resuming Quartz Job '{}'", (Object)name);
                    this.scheduler().resumeJob(job);
                    bl = true;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("No running Job named '{}' found: Cannot unpause", (Object)name);
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public void resumeAll() {
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Resuming all Quartz jobs.");
        this.scheduler().resumeAll();
    }

    public boolean cancelJob(String name) {
        Option option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.runningJobs().get((Object)name);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    JobKey job = (JobKey)some.x();
                    this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Cancelling Quartz Job '{}'", (Object)name);
                    boolean result = this.scheduler().deleteJob(job);
                    this.runningJobs().$minus$eq((Object)name);
                    bl = result;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().warning("No running Job named '{}' found: Cannot cancel", (Object)name);
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)option);
    }

    public Date createJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.schedule(name, receiver, msg);
    }

    public Option<String> createJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> createJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone createJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public Date updateJobSchedule(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        return this.rescheduleJob(name, receiver, msg, description, cronExpression, calendar, timezone);
    }

    public Option<String> updateJobSchedule$default$4() {
        return None$.MODULE$;
    }

    public Option<String> updateJobSchedule$default$6() {
        return None$.MODULE$;
    }

    public TimeZone updateJobSchedule$default$7() {
        return this.defaultTimezone();
    }

    public boolean deleteJobSchedule(String name) {
        return this.unscheduleJob(name);
    }

    /*
     * WARNING - void declaration
     */
    public boolean unscheduleJob(String name) {
        void var2_2;
        boolean isJobCancelled = this.cancelJob(name);
        if (isJobCancelled) {
            this.removeSchedule(name);
        }
        return (boolean)var2_2;
    }

    public void createSchedule(String name, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        Option option = this.schedules().get((Object)name);
        if (option instanceof Some) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A schedule with this name already exists: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        if (None$.MODULE$.equals(option)) {
            Either either = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class})).either((Function0)new Serializable(this, cronExpression){
                public static final long serialVersionUID = 0L;
                private final String cronExpression$1;

                public final CronExpression apply() {
                    return new CronExpression(this.cronExpression$1);
                }
                {
                    this.cronExpression$1 = cronExpression$1;
                }
            });
            if (either instanceof Left) {
                Left left = (Left)either;
                Throwable t = (Throwable)left.a();
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid 'expression' for Cron Schedule '", "'. Failed to validate CronExpression."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (either instanceof Right) {
                CronExpression expr;
                CronExpression cronExpression2;
                Right right = (Right)either;
                CronExpression expression = cronExpression2 = (expr = (CronExpression)right.b());
                QuartzCronSchedule quartzSchedule = new QuartzCronSchedule(name, description, expression, timezone, calendar);
                this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)this.schedules().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)quartzSchedule)));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError((Object)either);
        }
        throw new MatchError((Object)option);
    }

    public Option<String> createSchedule$default$2() {
        return None$.MODULE$;
    }

    public Option<String> createSchedule$default$4() {
        return None$.MODULE$;
    }

    public TimeZone createSchedule$default$5() {
        return this.defaultTimezone();
    }

    public Date rescheduleJob(String name, ActorRef receiver, Object msg, Option<String> description, String cronExpression, Option<String> calendar, TimeZone timezone) {
        this.cancelJob(name);
        this.removeSchedule(name);
        this.createSchedule(name, description, cronExpression, calendar, timezone);
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Option<String> rescheduleJob$default$4() {
        return None$.MODULE$;
    }

    public Option<String> rescheduleJob$default$6() {
        return None$.MODULE$;
    }

    public TimeZone rescheduleJob$default$7() {
        return this.defaultTimezone();
    }

    private void removeSchedule(String name) {
        this.schedules_$eq((scala.collection.immutable.Map<String, QuartzSchedule>)((scala.collection.immutable.Map)this.schedules().$minus((Object)name)));
    }

    public Date schedule(String name, ActorRef receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, EventStream receiver, Object msg) {
        return this.scheduleInternal(name, receiver, msg, (Option<Date>)None$.MODULE$);
    }

    public Date schedule(String name, ActorRef receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, ActorSelection receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    public Date schedule(String name, EventStream receiver, Object msg, Option<Date> startDate) {
        return this.scheduleInternal(name, receiver, msg, startDate);
    }

    private Date scheduleInternal(String name, Object receiver, Object msg, Option<Date> startDate) {
        Option option = this.schedules().get((Object)name);
        if (option instanceof Some) {
            Some some = (Some)option;
            QuartzSchedule schedule = (QuartzSchedule)some.x();
            Date date = this.scheduleJob(name, receiver, msg, startDate, schedule);
            return date;
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("No matching quartz configuration found for schedule '%s'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})));
        }
        throw new MatchError((Object)option);
    }

    public Date scheduleJob(String name, Object receiver, Object msg, Option<Date> startDate, QuartzSchedule schedule) {
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Setting up scheduled job '{}', with '{}'", (Object)name, (Object)schedule);
        scala.collection.immutable.Map jobDataMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"logBus"), (Object)this.system.eventStream()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"receiver"), receiver), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), msg)}));
        JobDataMap jobData = JobDataMapSupport.newJobDataMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)jobDataMap).asJava()));
        JobDetail job = JobBuilder.newJob(SimpleActorMessageJob.class).withIdentity(new StringBuilder().append((Object)name).append((Object)"_Job").toString()).usingJobData(jobData).withDescription((String)schedule.description().orNull(Predef$.MODULE$.$conforms())).build();
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Adding jobKey {} to runningJobs map.", (Object)job.getKey());
        this.runningJobs().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)job.getKey()));
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Building Trigger with startDate '{}", startDate.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Date apply() {
                return new Date();
            }
        }));
        Trigger trigger = schedule.buildTrigger(name, startDate);
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Scheduling Job '{}' and Trigger '{}'. Is Scheduler Running? {}", (Object)job, (Object)trigger, (Object)BoxesRunTime.boxToBoolean((boolean)this.scheduler().isStarted()));
        return this.scheduler().scheduleJob(job, trigger);
    }

    public void initialiseCalendars() {
        QuartzCalendars$.MODULE$.apply(this.config(), this.defaultTimezone()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Calendar> check$ifrefutable$1) {
                Tuple2<String, Calendar> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QuartzSchedulerExtension $outer;

            public final void apply(Tuple2<String, Calendar> x$1) {
                Tuple2<String, Calendar> tuple2 = x$1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    Calendar calendar = (Calendar)tuple2._2();
                    this.$outer.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info("Configuring Calendar '{}'", (Object)name);
                    this.$outer.scheduler().addCalendar(name, calendar, true, true);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialized calendars: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.scheduler().getCalendarNames()).asScala()).mkString(",")})));
    }

    public SimpleThreadPool threadPool() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.threadPool$lzycompute() : this.threadPool;
    }

    public JobStore jobStore() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.jobStore$lzycompute() : this.jobStore;
    }

    public Scheduler scheduler() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.scheduler$lzycompute() : this.scheduler;
    }

    public QuartzSchedulerExtension(ExtendedActorSystem system) {
        this.system = system;
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)this, package$.MODULE$.quartzExtensionLoggerType());
        this.config = system.settings().config().getConfig("akka.quartz").root().toConfig();
        this.threadCount = this.config().getInt("threadPool.threadCount");
        Predef$.MODULE$.require(this.threadCount() >= 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Quartz Thread Count (akka.quartz.threadPool.threadCount) must be a positive integer.";
            }
        });
        this.threadPriority = this.config().getInt("threadPool.threadPriority");
        Predef$.MODULE$.require(this.threadPriority() >= 1 && this.threadPriority() <= 10, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Quartz Thread Priority (akka.quartz.threadPool.threadPriority) must be a positive integer between 1 (lowest) and 10 (highest).";
            }
        });
        this.daemonThreads_$qmark = this.config().getBoolean("threadPool.daemonThreads");
        this.defaultTimezone = TimeZone.getTimeZone(this.config().getString("defaultTimezone"));
        this.schedules = QuartzSchedules$.MODULE$.apply(this.config(), this.defaultTimezone());
        this.runningJobs = Map$.MODULE$.empty();
        this.com$typesafe$akka$extension$quartz$QuartzSchedulerExtension$$log().debug("Configured Schedules: {}", this.schedules());
        this.scheduler().start();
        this.initialiseCalendars();
    }
}

