/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.akka.extension.quartz;

import com.typesafe.akka.extension.quartz.QuartzCronSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedule;
import com.typesafe.akka.extension.quartz.QuartzSchedules$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.text.ParseException;
import java.util.TimeZone;
import org.quartz.CronExpression;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.Exception;
import scala.util.control.Exception$;

public final class QuartzSchedules$ {
    public static final QuartzSchedules$ MODULE$;
    private final Exception.Catch<Nothing$> catchMissing;
    private final Exception.Catch<Nothing$> catchWrongType;
    private final Exception.Catch<Nothing$> catchParseErr;

    static {
        new QuartzSchedules$();
    }

    public Exception.Catch<Nothing$> catchMissing() {
        return this.catchMissing;
    }

    public Exception.Catch<Nothing$> catchWrongType() {
        return this.catchWrongType;
    }

    public Exception.Catch<Nothing$> catchParseErr() {
        return this.catchParseErr;
    }

    public Map<String, QuartzSchedule> apply(Config config, TimeZone defaultTimezone) {
        return (Map)this.catchMissing().opt((Function0)new Serializable(config, defaultTimezone){
            public static final long serialVersionUID = 0L;
            private final Config config$1;
            public final TimeZone defaultTimezone$1;

            public final Map<String, QuartzSchedule> apply() {
                return (Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.config$1.getConfig("schedules").root()).asScala()).toMap(Predef$.MODULE$.$conforms()).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.apply.1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Iterable<Tuple2<String, QuartzSchedule>> apply(Tuple2<String, ConfigValue> x0$1) {
                        Tuple2<String, ConfigValue> tuple2 = x0$1;
                        if (tuple2 == null) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        String key = (String)tuple2._1();
                        ConfigValue value = (ConfigValue)tuple2._2();
                        if (!(value instanceof ConfigObject)) return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        ConfigObject configObject = (ConfigObject)value;
                        return Option$.MODULE$.option2Iterable((Option)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)QuartzSchedules$.MODULE$.parseSchedule(key, configObject.toConfig(), this.$outer.defaultTimezone$1))));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Map$.MODULE$.canBuildFrom());
            }
            {
                this.config$1 = config$1;
                this.defaultTimezone$1 = defaultTimezone$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, QuartzSchedule> apply() {
                return Map$.MODULE$.empty();
            }
        });
    }

    public QuartzSchedule parseSchedule(String name, Config config, TimeZone defaultTimezone) {
        TimeZone timezone = (TimeZone)this.catchMissing().opt((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$2;

            public final TimeZone apply() {
                return TimeZone.getTimeZone(this.config$2.getString("timezone"));
            }
            {
                this.config$2 = config$2;
            }
        }).getOrElse((Function0)new Serializable(defaultTimezone){
            public static final long serialVersionUID = 0L;
            private final TimeZone defaultTimezone$2;

            public final TimeZone apply() {
                return this.defaultTimezone$2;
            }
            {
                this.defaultTimezone$2 = defaultTimezone$2;
            }
        });
        Option calendar = (Option)this.catchMissing().opt((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$2;

            public final Option<String> apply() {
                return Option$.MODULE$.apply((Object)this.config$2.getString("calendar"));
            }
            {
                this.config$2 = config$2;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final None$ apply() {
                return None$.MODULE$;
            }
        });
        Option desc = this.catchMissing().opt((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$2;

            public final String apply() {
                return this.config$2.getString("description");
            }
            {
                this.config$2 = config$2;
            }
        });
        return this.parseCronSchedule(name, (Option<String>)desc, config, timezone, (Option<String>)calendar);
    }

    public QuartzCronSchedule parseCronSchedule(String name, Option<String> desc, Config config, TimeZone tz, Option<String> calendar) {
        Either either = this.catchMissing().or(this.catchWrongType()).either((Function0)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final Config config$3;

            public final String apply() {
                return this.config$3.getString("expression");
            }
            {
                this.config$3 = config$3;
            }
        });
        if (either instanceof Left) {
            Left left = (Left)either;
            Throwable t = (Throwable)left.a();
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid or Missing Configuration entry 'expression' for Cron Schedule '%s'. You must provide a valid Quartz CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            String str = (String)right.b();
            Either either2 = this.catchParseErr().either((Function0)new Serializable(str){
                public static final long serialVersionUID = 0L;
                private final String str$1;

                public final CronExpression apply() {
                    return new CronExpression(this.str$1);
                }
                {
                    this.str$1 = str$1;
                }
            });
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                Throwable t = (Throwable)left.a();
                throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Invalid 'expression' for Cron Schedule '%s'. Failed to validate CronExpression.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), t);
            }
            if (either2 instanceof Right) {
                CronExpression expr;
                CronExpression cronExpression;
                CronExpression cronExpression2;
                Right right2 = (Right)either2;
                CronExpression expression = cronExpression2 = (cronExpression = (expr = (CronExpression)right2.b()));
                return new QuartzCronSchedule(name, desc, expression, tz, calendar);
            }
            throw new MatchError((Object)either2);
        }
        throw new MatchError((Object)either);
    }

    private QuartzSchedules$() {
        MODULE$ = this;
        this.catchMissing = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.Missing.class}));
        this.catchWrongType = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ConfigException.WrongType.class}));
        this.catchParseErr = Exception$.MODULE$.catching((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ParseException.class}));
    }
}

