/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.handlers.proxy;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.SelfHealingEngine;
import com.epam.healenium.handlers.proxy.BaseHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebElementProxyHandler
extends BaseHandler {
    private static final Logger log = LoggerFactory.getLogger(WebElementProxyHandler.class);
    private final WebElement delegate;

    public WebElementProxyHandler(WebElement delegate, SelfHealingEngine engine) {
        super(engine);
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            ClassLoader loader = this.driver.getClass().getClassLoader();
            if ("findElement".equals(method.getName())) {
                WebElement element = this.findElement((By)args[0]);
                return Optional.ofNullable(element).map(it -> this.wrapElement((WebElement)it, loader)).orElse(null);
            }
            if ("findElements".equals(method.getName())) {
                List<WebElement> elements = this.findElements((By)args[0]);
                return elements.stream().map(it -> this.wrapElement((WebElement)it, loader)).collect(Collectors.toList());
            }
            if ("getWrappedElement".equals(method.getName())) {
                return this.delegate;
            }
            return method.invoke((Object)this.delegate, args);
        }
        catch (Exception ex) {
            throw ex.getCause();
        }
    }

    @Override
    protected WebElement findElement(By by) {
        try {
            PageAwareBy pageBy = this.awareBy(by);
            if (this.engine.isHealingEnabled()) {
                return this.lookUp(pageBy);
            }
            return this.delegate.findElement(pageBy.getBy());
        }
        catch (Exception ex) {
            throw new NoSuchElementException("Failed to find element using " + by.toString(), (Throwable)ex);
        }
    }

    @Override
    protected WebElement lookUp(PageAwareBy key) {
        try {
            WebElement element = this.delegate.findElement(key.getBy());
            this.engine.saveElements(key, Collections.singletonList(element));
            return element;
        }
        catch (NoSuchElementException ex) {
            log.warn("Failed to find an element using locator {}\nReason: {}\nTrying to heal...", (Object)key.getBy().toString(), (Object)ex.getMessage());
            return this.getHealingService().heal(key, ex).orElseThrow(() -> ex);
        }
    }
}

