/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.mapper;

import com.epam.healenium.model.HealingResultDto;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.RequestDto;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.utils.StackUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class HealeniumMapper {
    public RequestDto buildDto(By by) {
        StackTraceElement traceElement = StackUtils.findOriginCaller(Thread.currentThread().getStackTrace()).orElseThrow(() -> new IllegalArgumentException("Failed to detect origin method caller"));
        String[] locatorParts = by.toString().split(":", 2);
        RequestDto dto = new RequestDto().setLocator(locatorParts[1].trim()).setType(locatorParts[0].trim());
        dto.setClassName(traceElement.getClassName());
        dto.setMethodName(traceElement.getMethodName());
        return dto;
    }

    public RequestDto buildDto(By by, List<List<Node>> nodePath) {
        RequestDto dto = this.buildDto(by);
        dto.setNodePath(nodePath);
        return dto;
    }

    public RequestDto buildDto(By by, String page, List<Scored<By>> healingResults, Scored<By> selected, byte[] screenshot) {
        RequestDto dto = this.buildDto(by);
        dto.setPageContent(page).setResults(this.buildResultDto(healingResults)).setUsedResult(this.buildResultDto(selected)).setScreenshot(screenshot);
        return dto;
    }

    public HealingResultDto buildResultDto(Scored<By> scored) {
        return new HealingResultDto(this.byToLocator((By)scored.getValue()), scored.getScore());
    }

    public List<HealingResultDto> buildResultDto(Collection<Scored<By>> scored) {
        return scored.stream().map(this::buildResultDto).collect(Collectors.toList());
    }

    public Locator byToLocator(By by) {
        String[] locatorParts = by.toString().split(":", 2);
        return new Locator(locatorParts[1].trim(), locatorParts[0].trim());
    }

    public List<Locator> byToLocator(Collection<By> by) {
        return by.stream().map(this::byToLocator).collect(Collectors.toList());
    }
}

