/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.utils;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtils {
    private static final Logger log = LoggerFactory.getLogger(SystemUtils.class);

    public static String getHostProjectName() {
        String projectPath = System.getProperty("user.dir").replace("\\", "/");
        return projectPath.substring(projectPath.lastIndexOf("/") + 1);
    }

    public static String getHostIpAddress() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            log.warn("Failed to get host address", (Throwable)ex);
            return "";
        }
    }

    private SystemUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

