/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium;

import com.epam.healenium.PageAwareBy;
import com.epam.healenium.annotation.DisableHealing;
import com.epam.healenium.client.RestClient;
import com.epam.healenium.model.Locator;
import com.epam.healenium.service.HealingService;
import com.epam.healenium.service.NodeService;
import com.epam.healenium.treecomparing.JsoupHTMLParser;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.utils.StackUtils;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfHealingEngine {
    private static final Logger log = LoggerFactory.getLogger(SelfHealingEngine.class);
    private static final Config DEFAULT_CONFIG = ConfigFactory.systemProperties().withFallback((ConfigMergeable)ConfigFactory.load((String)"healenium.properties").withFallback((ConfigMergeable)ConfigFactory.load()));
    private final Config config;
    private final WebDriver webDriver;
    private final double scoreCap;
    private final RestClient client;
    private final NodeService nodeService;
    private final HealingService healingService;

    public SelfHealingEngine(@NotNull WebDriver delegate, @NotNull Config config) {
        Config finalizedConfig = ConfigFactory.load((Config)config).withFallback((ConfigMergeable)DEFAULT_CONFIG);
        this.webDriver = delegate;
        this.config = finalizedConfig;
        this.scoreCap = finalizedConfig.getDouble("score-cap");
        this.client = new RestClient(finalizedConfig);
        this.nodeService = new NodeService(delegate);
        this.healingService = new HealingService(finalizedConfig, delegate);
    }

    public SelfHealingEngine(@NotNull WebDriver delegate) {
        this(delegate, DEFAULT_CONFIG);
    }

    public void saveElements(PageAwareBy by, List<WebElement> webElements) {
        List<List<Node>> nodesToSave = webElements.stream().map(this.nodeService::getNodePath).collect(Collectors.toList());
        this.saveNodes(by, nodesToSave);
    }

    public void saveNodes(PageAwareBy key, List<List<Node>> elementsToSave) {
        this.client.selectorsRequest(key.getBy(), new ArrayList<List<Node>>(elementsToSave), this.getCurrentUrl());
    }

    public Optional<Scored<By>> toLocator(List<Locator> imitatedLocators, Double score) {
        for (Locator imitatedLocator : imitatedLocators) {
            By locator = StackUtils.BY_MAP.get(imitatedLocator.getType()).apply(imitatedLocator.getValue());
            List elements = this.webDriver.findElements(locator);
            if (elements.size() != 1) continue;
            return Optional.of(new Scored(score.doubleValue(), (Object)locator));
        }
        return Optional.empty();
    }

    public String pageSource() {
        if (this.webDriver instanceof JavascriptExecutor) {
            return ((JavascriptExecutor)this.webDriver).executeScript("return document.body.outerHTML;", new Object[0]).toString();
        }
        return this.webDriver.getPageSource();
    }

    public Node parseTree(String tree) {
        return new JsoupHTMLParser().parse((InputStream)new ByteArrayInputStream(tree.getBytes(StandardCharsets.UTF_8)));
    }

    public boolean isHealingEnabled() {
        boolean isDisabled = StackUtils.isAnnotationPresent(DisableHealing.class);
        return this.config.getBoolean("heal-enabled") && !isDisabled;
    }

    public boolean isHealingBacklighted() {
        return this.config.getBoolean("backlight-healing");
    }

    public String getCurrentUrl() {
        return this.webDriver.getCurrentUrl().split("://")[1];
    }

    public Config getConfig() {
        return this.config;
    }

    public WebDriver getWebDriver() {
        return this.webDriver;
    }

    public double getScoreCap() {
        return this.scoreCap;
    }

    public RestClient getClient() {
        return this.client;
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public HealingService getHealingService() {
        return this.healingService;
    }
}

