/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.client;

import com.epam.healenium.converter.NodeDeserializer;
import com.epam.healenium.converter.NodeSerializer;
import com.epam.healenium.mapper.HealeniumMapper;
import com.epam.healenium.model.Context;
import com.epam.healenium.model.HealedElement;
import com.epam.healenium.model.HealeniumSelectorImitatorDto;
import com.epam.healenium.model.HealingResult;
import com.epam.healenium.model.HealingResultRequestDto;
import com.epam.healenium.model.LastHealingDataDto;
import com.epam.healenium.model.Locator;
import com.epam.healenium.model.RequestDto;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.Scored;
import com.epam.healenium.utils.SystemUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.By;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestClient {
    private static final Logger log = LoggerFactory.getLogger(RestClient.class);
    private final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private final String baseUrl;
    private final String imitateUrl;
    private final String sessionKey;
    private final ObjectMapper objectMapper = this.initMapper();
    private final HealeniumMapper mapper;

    public RestClient(Config config) {
        this.baseUrl = "http://" + config.getString("serverHost") + ":" + config.getInt("serverPort") + "/healenium";
        this.imitateUrl = "http://" + config.getString("serverHost") + ":" + config.getInt("imitatePort") + "/imitate";
        this.sessionKey = config.hasPath("sessionKey") ? config.getString("sessionKey") : "";
        this.mapper = new HealeniumMapper();
    }

    private OkHttpClient okHttpClient() {
        return new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    }

    private ObjectMapper initMapper() {
        SimpleModule module = new SimpleModule("node");
        module.addSerializer(Node.class, (JsonSerializer)new NodeSerializer());
        module.addDeserializer(Node.class, (JsonDeserializer)new NodeDeserializer());
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)module);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        return mapper;
    }

    public void selectorsRequest(By by, List<List<Node>> nodePath, String currentUrl) {
        RequestDto requestDto = this.mapper.buildDto(by, nodePath, currentUrl);
        try {
            RequestBody body = RequestBody.create((MediaType)this.JSON, (String)this.objectMapper.writeValueAsString((Object)requestDto));
            Request request = new Request.Builder().url(this.baseUrl).post(body).build();
            this.okHttpClient().newCall(request).execute().close();
        }
        catch (Exception e) {
            log.warn("Failed to make response of 'selectorsRequest' request." + e);
        }
    }

    public void healRequest(Context context) {
        try {
            ArrayList<HealingResultRequestDto> resultRequestDtos = new ArrayList<HealingResultRequestDto>();
            for (HealingResult healingResult : context.getHealingResults()) {
                List<Scored<By>> choices = healingResult.getHealedElements().stream().map(HealedElement::getScored).collect(Collectors.toList());
                if (choices.isEmpty()) {
                    return;
                }
                String metrics = this.objectMapper.writeValueAsString((Object)healingResult.getMetricsDto());
                resultRequestDtos.add(this.mapper.buildMultRequest(context, healingResult, choices, metrics));
            }
            RequestBody requestBody = RequestBody.create((MediaType)this.JSON, (String)this.objectMapper.writeValueAsString(resultRequestDtos));
            Request request = new Request.Builder().addHeader("sessionKey", this.sessionKey).addHeader("hostProject", SystemUtils.getHostProjectName()).url(this.baseUrl + "/healing").post(requestBody).build();
            this.okHttpClient().newCall(request).execute().close();
        }
        catch (Exception e) {
            log.warn("Failed to make response of 'healRequest' request. ", (Throwable)e);
        }
    }

    public Optional<LastHealingDataDto> getLastHealingData(By locator, String currentUrl) {
        LastHealingDataDto lastHealingDataDto = null;
        RequestDto requestDto = this.mapper.buildDto(locator, currentUrl);
        try {
            HttpUrl.Builder httpBuilder = HttpUrl.parse((String)this.baseUrl).newBuilder().addQueryParameter("locator", requestDto.getLocator()).addQueryParameter("className", requestDto.getClassName()).addQueryParameter("methodName", requestDto.getMethodName()).addQueryParameter("url", currentUrl);
            Request request = new Request.Builder().addHeader("sessionKey", this.sessionKey).url(httpBuilder.build()).get().build();
            try (Response response = this.okHttpClient().newCall(request).execute();){
                if (response.code() == 200) {
                    String result = response.body().string();
                    lastHealingDataDto = (LastHealingDataDto)this.objectMapper.readValue(result, (TypeReference)new TypeReference<LastHealingDataDto>(){});
                }
            }
        }
        catch (Exception ex) {
            log.warn("Failed to make response of 'getLastHealingData' request. ", (Throwable)ex);
        }
        return Optional.ofNullable(lastHealingDataDto);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Locator> imitate(HealeniumSelectorImitatorDto healeniumSelectorImitatorDto) {
        try {
            RequestBody body = RequestBody.create((MediaType)this.JSON, (String)this.objectMapper.writeValueAsString((Object)healeniumSelectorImitatorDto));
            Request request = new Request.Builder().url(this.imitateUrl).post(body).build();
            try (Response response = this.okHttpClient().newCall(request).execute();){
                if (response.code() != 200) return Collections.emptyList();
                String result = response.body().string();
                List list = (List)this.objectMapper.readValue(result, (TypeReference)new TypeReference<List<Locator>>(){});
                return list;
            }
        }
        catch (Exception ex) {
            log.warn("Failed to make imitate response of 'imitate' request. ", (Throwable)ex);
        }
        return Collections.emptyList();
    }
}

