/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.LastHealingDataDto;
import com.epam.healenium.processor.BaseProcessor;
import com.epam.healenium.treecomparing.Node;
import java.util.List;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealingElementsProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(HealingElementsProcessor.class);

    public HealingElementsProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public boolean validate() {
        LastHealingDataDto lastHealingData = this.context.getLastHealingData();
        if ((lastHealingData == null || lastHealingData.getPaths().isEmpty()) && !this.context.getElements().isEmpty()) {
            this.engine.saveElements(this.context.getPageAwareBy(), this.context.getElements());
            return false;
        }
        return true;
    }

    @Override
    public void execute() {
        List<List<Node>> nodesFromDb = this.context.getLastHealingData().getPaths();
        this.splitDbNodes(nodesFromDb);
        String targetPage = this.engine.pageSource();
        Node destination = this.engine.parseTree(targetPage);
        this.context.setPageContent(targetPage);
        nodesFromDb.stream().filter(nodes -> !this.context.getNewElementsToNodes().containsValue(nodes) && !this.context.getExistElementsToNodes().containsValue(nodes)).forEach(nodes -> this.healingService.findNewLocations((List<Node>)nodes, destination, this.context));
    }

    private void splitDbNodes(List<List<Node>> nodesFromDb) {
        for (WebElement webElement : this.context.getElements()) {
            List<Node> nodePath = this.engine.getNodeService().getNodePath(webElement);
            if (!nodesFromDb.contains(nodePath)) {
                this.context.getNewElementsToNodes().put(webElement, nodePath);
                continue;
            }
            this.context.getExistElementsToNodes().put(webElement, nodePath);
        }
    }
}

