/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.processor;

import com.epam.healenium.model.HealingResult;
import com.epam.healenium.processor.BaseProcessor;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveHealingResultsProcessor
extends BaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(SaveHealingResultsProcessor.class);

    public SaveHealingResultsProcessor(BaseProcessor nextProcessor) {
        super(nextProcessor);
    }

    @Override
    public void execute() {
        this.context.getHealingResults().forEach(this::enrichHealingResult);
        if (!this.context.getHealingResults().isEmpty()) {
            this.restClient.healRequest(this.context);
        }
    }

    public void enrichHealingResult(HealingResult healingResult) {
        WebElement mainHealedElement = healingResult.getHealedElements().get(0).getElement();
        byte[] screenshot = this.captureScreen(mainHealedElement);
        healingResult.setScreenshot(screenshot);
        this.context.getElements().add(mainHealedElement);
    }

    protected byte[] captureScreen(WebElement element) {
        if (this.engine.isHealingBacklighted()) {
            JavascriptExecutor jse = (JavascriptExecutor)this.driver;
            jse.executeScript("arguments[0].style.border='3px solid red'", new Object[]{element});
        }
        return (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
    }
}

