/*
 * Decompiled with CFR 0.152.
 */
package com.epam.healenium.service;

import com.epam.healenium.SelectorComponent;
import com.epam.healenium.model.Context;
import com.epam.healenium.model.HealedElement;
import com.epam.healenium.model.HealingCandidateDto;
import com.epam.healenium.model.HealingResult;
import com.epam.healenium.treecomparing.HeuristicNodeDistance;
import com.epam.healenium.treecomparing.LCSPathDistance;
import com.epam.healenium.treecomparing.Node;
import com.epam.healenium.treecomparing.NodeDistance;
import com.epam.healenium.treecomparing.Path;
import com.epam.healenium.treecomparing.PathDistance;
import com.epam.healenium.treecomparing.PathFinder;
import com.epam.healenium.treecomparing.Scored;
import com.typesafe.config.Config;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.RemoteWebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealingService {
    private static final Logger log = LoggerFactory.getLogger(HealingService.class);
    private final int recoveryTries;
    private final double scoreCap;
    private final List<Set<SelectorComponent>> selectorDetailLevels;
    private final WebDriver driver;
    private static final List<Set<SelectorComponent>> TEMP = new ArrayList<Set<SelectorComponent>>(){
        {
            this.add(EnumSet.of(SelectorComponent.TAG, SelectorComponent.ID));
            this.add(EnumSet.of(SelectorComponent.TAG, SelectorComponent.CLASS));
            this.add(EnumSet.of(SelectorComponent.PARENT, SelectorComponent.TAG, SelectorComponent.ID, SelectorComponent.CLASS));
            this.add(EnumSet.of(SelectorComponent.PARENT, SelectorComponent.TAG, SelectorComponent.CLASS, SelectorComponent.POSITION));
            this.add(EnumSet.of(SelectorComponent.PARENT, SelectorComponent.TAG, SelectorComponent.ID, SelectorComponent.CLASS, SelectorComponent.ATTRIBUTES));
            this.add(EnumSet.of(SelectorComponent.PATH));
        }
    };

    public HealingService(Config finalizedConfig, WebDriver driver) {
        this.recoveryTries = finalizedConfig.getInt("recovery-tries");
        this.scoreCap = finalizedConfig.getDouble("score-cap");
        this.selectorDetailLevels = Collections.unmodifiableList(TEMP);
        this.driver = driver;
    }

    public void findNewLocations(List<Node> paths, Node destination, Context context) {
        long then = System.currentTimeMillis();
        PathFinder pathFinder = new PathFinder((PathDistance)new LCSPathDistance(), (NodeDistance)new HeuristicNodeDistance());
        AbstractMap.SimpleImmutableEntry scoresToNodes = pathFinder.findScoresToNodes(new Path(paths.toArray(new Node[0])), destination);
        List scoreds = pathFinder.getSortedNodes((Map)scoresToNodes.getValue(), this.recoveryTries, this.scoreCap);
        List<HealedElement> healedElements = scoreds.stream().map(node -> this.toLocator((Scored<Node>)node, context)).filter(Objects::nonNull).collect(Collectors.toList());
        String healingTime = String.valueOf((double)(System.currentTimeMillis() - then) / 1000.0);
        if (!healedElements.isEmpty()) {
            HealingResult healingResult = new HealingResult().setPaths(paths).setTargetNodes(scoreds).setAllHealingCandidates(this.getAllHealingCandidates(scoresToNodes)).setHealingTime(healingTime).setHealedElements(healedElements);
            context.getHealingResults().add(healingResult);
        }
    }

    private HealedElement toLocator(Scored<Node> node, Context context) {
        for (Set<SelectorComponent> detailLevel : this.selectorDetailLevels) {
            By locator = this.construct((Node)node.getValue(), detailLevel);
            List elements = this.driver.findElements(locator);
            if (elements.size() != 1 || context.getElementIds().contains(((RemoteWebElement)elements.get(0)).getId())) continue;
            Scored byScored = new Scored(node.getScore(), (Object)locator);
            context.getElementIds().add(((RemoteWebElement)elements.get(0)).getId());
            HealedElement healedElement = new HealedElement();
            healedElement.setElement((WebElement)elements.get(0)).setScored((Scored<By>)byScored);
            return healedElement;
        }
        return null;
    }

    private List<HealingCandidateDto> getAllHealingCandidates(AbstractMap.SimpleImmutableEntry<Integer, Map<Double, List<AbstractMap.SimpleImmutableEntry<Node, Integer>>>> curPathHeightToScores) {
        Integer curPathHeight = curPathHeightToScores.getKey();
        Map<Double, List<AbstractMap.SimpleImmutableEntry<Node, Integer>>> scoresToNodes = curPathHeightToScores.getValue();
        return scoresToNodes.keySet().stream().sorted(Comparator.reverseOrder()).flatMap(score -> ((List)scoresToNodes.get(score)).stream().map(it -> new HealingCandidateDto((Double)score, (Integer)it.getValue(), curPathHeight, (Node)it.getKey()))).limit(10L).collect(Collectors.toList());
    }

    private By construct(Node node, Set<SelectorComponent> detailLevel) {
        return By.cssSelector((String)detailLevel.stream().map(component -> component.createComponent(node)).collect(Collectors.joining()));
    }
}

